/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.util.IOUtils;
import io.thekraken.grok.api.Grok;
import io.thekraken.grok.api.Match;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCLogReader
extends AbstractReader {
    private static Logger LOG = LoggerFactory.getLogger(GCLogReader.class);
    private Grok grok;
    private Boolean keepRaw;
    private String filename;
    private String currentFileName;

    @Override
    public void read() {
        try {
            String conffilename = this.getProperty("filename", null);
            this.filename = IOUtils.getAbsoluteFile(this.getBaseDir(), conffilename);
            this.keepRaw = this.getPropertyAsBoolean("keepRaw", false);
            String grokPatternPath = "src/main/grok/patterns/gc";
            this.grok = Grok.create((String)grokPatternPath);
            this.grok.addPatternFromFile("src/main/grok/patterns/patterns");
            this.grok.compile("^%{TIMESTAMP_ISO8601:date}");
            List<String> fileList = IOUtils.getFiles(this.filename);
            Iterator<String> iterator = fileList.iterator();
            while (iterator.hasNext()) {
                String line;
                String file;
                this.currentFileName = file = iterator.next();
                InputStream in = IOUtils.getInputStream(file);
                InputStreamReader isr = new InputStreamReader(in);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    this.processLine(line);
                }
                br.close();
            }
            this.executer.end();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void processLine(String line) {
        LOG.info(line);
        Match gm = this.grok.match(line);
        gm.captures();
        Map m = gm.toMap();
        Document document = new Document();
        for (Map.Entry entry : m.entrySet()) {
            Object value = entry.getValue();
            document.addField((String)entry.getKey(), String.valueOf(value));
        }
        if (!m.isEmpty()) {
            document.addField("filename", this.currentFileName);
            if (this.keepRaw.booleanValue()) {
                document.addField("raw", line);
            }
            this.executer.document(document);
        }
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void end() {
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

