/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.quasiris.qsc.writer.QscDataPushWriter;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.filter.SimpleMapping;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLReader
extends AbstractReader {
    private static final Logger LOG = LoggerFactory.getLogger(QscDataPushWriter.class);
    private static final Gson gson = new Gson();
    public static final String PROPERTY_BATCH_SIZE = "batchSize";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_HEADER = "header";
    public static final String PROPERTY_QUERY_TEXT_FILEPATH = "queryTextFilepath";
    public static final String PROPERTY_QUERY_TOTAL_TEXT_FILEPATH = "queryTotalTextFilepath";
    public static final String PROPERTY_QUERY_TEXTS_BATCH_SIZE_LABEL = "queryTextsBatchSizeLabel";
    public static final String PROPERTY_QUERY_TEXTS_CURRENT_BATCH_LABEL = "queryTextsCurrentBatchLabel";
    public static final String PROPERTY_TOTAL_BATCHES_JSON_PATH = "totalBatchesJsonPath";
    public static final String PROPERTY_ENTRIES_JSON_PATH = "entriesJsonPath";
    public static final String PROPERTY_ERRORS_JSON_PATH = "errorsJsonPath";
    public static final String PROPERTY_JSON_MAPPING = "jsonMapping";
    public static final String PROPERTY_JSON_MAPPING_CONFIG = "jsonMappingConfig";
    public static final Long PROPERTY_DEFAULT_BATCH_SIZE = 100L;
    public static final String PROPERTY_DEFAULT_QUERY_TEXTS_BATCH_SIZE_LABEL = "batchSize";
    public static final String PROPERTY_DEFAULT_QUERY_TEXTS_CURRENT_BATCH_LABEL = "currentBatch";
    public static final String PROPERTY_DEFAULT_ERRORS_JSON_PATH = "$.errors";
    int batchSize = Math.toIntExact(PROPERTY_DEFAULT_BATCH_SIZE);
    String url = null;
    List<String> header = new ArrayList<String>();
    String queryTextFilepath = null;
    String queryTotalTextFilepath = null;
    String queryTextsBatchSizeLabel = "batchSize";
    String queryTextsCurrentBatchLabel = "currentBatch";
    String totalBatchesJsonPath = null;
    String entriesJsonPath = null;
    String errorsJsonPath = null;
    Map<String, List<String>> mapping = new HashMap<String, List<String>>();

    @Override
    public void read() {
        String queryTotalText;
        String queryText;
        this.batchSize = Math.toIntExact(this.getPropertyAsInteger("batchSize", PROPERTY_DEFAULT_BATCH_SIZE));
        this.url = this.getProperty(PROPERTY_URL, null);
        this.header = this.getPropertyAsList(PROPERTY_HEADER, null);
        this.queryTextFilepath = this.getProperty(PROPERTY_QUERY_TEXT_FILEPATH, null);
        this.queryTotalTextFilepath = this.getProperty(PROPERTY_QUERY_TOTAL_TEXT_FILEPATH, this.queryTextFilepath);
        this.queryTextsBatchSizeLabel = this.getProperty(PROPERTY_QUERY_TEXTS_BATCH_SIZE_LABEL, "batchSize");
        this.queryTextsCurrentBatchLabel = this.getProperty(PROPERTY_QUERY_TEXTS_CURRENT_BATCH_LABEL, PROPERTY_DEFAULT_QUERY_TEXTS_CURRENT_BATCH_LABEL);
        this.totalBatchesJsonPath = this.getProperty(PROPERTY_TOTAL_BATCHES_JSON_PATH, null);
        this.entriesJsonPath = this.getProperty(PROPERTY_ENTRIES_JSON_PATH, null);
        this.errorsJsonPath = this.getProperty(PROPERTY_ERRORS_JSON_PATH, PROPERTY_DEFAULT_ERRORS_JSON_PATH);
        SimpleMapping simpleMapping = new SimpleMapping(this.getPropertyAsList(PROPERTY_JSON_MAPPING, new ArrayList<String>()), this.getPropertyAsList(PROPERTY_JSON_MAPPING_CONFIG, new ArrayList<String>()));
        this.mapping = simpleMapping.getMapping();
        String prefix = " The GraphQLReader Property '";
        String suffix = "' is missing in your pipeline configuration!";
        if (this.url == null) {
            throw new RuntimeException(prefix + PROPERTY_URL + suffix);
        }
        if (this.queryTextFilepath == null) {
            throw new RuntimeException(prefix + PROPERTY_QUERY_TEXT_FILEPATH + suffix);
        }
        if (this.totalBatchesJsonPath == null) {
            throw new RuntimeException(prefix + PROPERTY_TOTAL_BATCHES_JSON_PATH + suffix);
        }
        if (this.entriesJsonPath == null) {
            throw new RuntimeException(prefix + PROPERTY_ENTRIES_JSON_PATH + suffix);
        }
        if (this.mapping == null) {
            throw new RuntimeException(prefix + PROPERTY_JSON_MAPPING + suffix);
        }
        try {
            queryText = this.readFileToString(this.queryTextFilepath);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read query text config file: '" + this.queryTextFilepath + "'", e);
        }
        try {
            queryTotalText = this.readFileToString(this.queryTotalTextFilepath);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read query total text config file: '" + this.queryTotalTextFilepath + "'", e);
        }
        int maxBatch = this.getTotalBatches(queryTotalText);
        for (int currentBatch = 1; currentBatch <= maxBatch; ++currentBatch) {
            LOG.info("Processing batch " + currentBatch + " of " + maxBatch);
            try {
                JsonArray entries = this.collectData(currentBatch, queryText);
                for (JsonElement entry : entries) {
                    this.executer.document(this.parseJsonEntryToDocument(entry, this.mapping));
                }
                continue;
            }
            catch (RuntimeException e) {
                LOG.info("Could not collect / parse batch " + currentBatch + ", skipping it.");
            }
        }
        LOG.info("Processing finished");
    }

    private Document parseJsonEntryToDocument(JsonElement entry, Map<String, List<String>> mapping) {
        Document document = new Document();
        for (String jsonPath : mapping.keySet()) {
            List<String> documentFieldsList = mapping.get(jsonPath);
            try {
                Object jsonAttribute = JsonPath.read((String)entry.toString(), (String)jsonPath, (Predicate[])new Predicate[0]);
                for (String documentField : documentFieldsList) {
                    document.setField(documentField, jsonAttribute);
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
            }
        }
        return document;
    }

    public int getTotalBatches(String queryTotalText) throws RuntimeException {
        JsonElement answerJson;
        String queryText = this.buildQuery(queryTotalText, 1);
        try {
            answerJson = this.graphQLRequest(queryText);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while collecting the amount of total batches from the endpoint " + this.url + "\n  The following query could not be executed: " + queryText, e);
        }
        JsonElement totalBatchesJson = this.getContent(answerJson, this.totalBatchesJsonPath);
        if (totalBatchesJson.equals(new JsonPrimitive("null"))) {
            JsonElement errorMsg = this.getContent(answerJson, this.errorsJsonPath);
            if (!errorMsg.equals(new JsonPrimitive("null"))) {
                throw new RuntimeException("Amount of total batches could not be retrieved from graphQL endpoint\n  The following error message was received from the endpoint: " + errorMsg.getAsJsonArray().toString());
            }
            throw new RuntimeException("Amount of total batches could not be retrieved from graphQL endpoint\n  No error message was received from the endpoint");
        }
        return totalBatchesJson.getAsInt();
    }

    public JsonArray collectData(int currentBatch, String queryText) throws RuntimeException {
        JsonElement answerJson;
        String query = this.buildQuery(queryText, currentBatch);
        try {
            answerJson = this.graphQLRequest(query);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while collecting data from the endpoint " + this.url + "\n  The following query could not be executed: " + queryText, e);
        }
        JsonElement entries = this.getContent(answerJson, this.entriesJsonPath);
        if (entries.equals(new JsonPrimitive("null"))) {
            JsonElement errorMsg = this.getContent(answerJson, this.errorsJsonPath);
            if (!errorMsg.equals(new JsonPrimitive("null"))) {
                throw new RuntimeException("List of entries could not be retrieved from graphQL endpoint\n  The following error message was received from the endpoint: " + errorMsg.getAsJsonArray().toString());
            }
            throw new RuntimeException("List of entries could not be retrieved from graphQL endpoint\n  No error message was received from the endpoint");
        }
        return entries.getAsJsonArray();
    }

    private String buildQuery(String queryText, int currentBatch) {
        return queryText.replace(this.queryTextsBatchSizeLabel, String.valueOf(this.batchSize)).replace(this.queryTextsCurrentBatchLabel, String.valueOf(currentBatch));
    }

    private JsonElement graphQLRequest(String queryText) throws IOException {
        String responseString = HTTPHelper.post(this.url, queryText, this.header);
        return (JsonElement)gson.fromJson(responseString, JsonElement.class);
    }

    public JsonElement getContent(JsonElement jsonElement, String path) {
        String content;
        try {
            content = JsonPath.read((String)jsonElement.toString(), (String)path, (Predicate[])new Predicate[0]).toString();
        }
        catch (PathNotFoundException e) {
            return new JsonPrimitive("null");
        }
        if (content.contains("{") || content.contains("[")) {
            JsonParser parser = new JsonParser();
            return parser.parse(content);
        }
        return new JsonPrimitive(content);
    }

    public String readFileToString(String path) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])));
    }
}

