/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcReader
extends AbstractReader {
    @Override
    public void read() {
        String sql = this.getProperty("sql", null);
        String jdbcDriver = this.getProperty("jdbcDriver", "com.mysql.jdbc.Driver");
        String user = this.getProperty("user", null);
        String password = this.getProperty("password", null);
        String jdbcUrl = this.getProperty("jdbcUrl", null);
        String zoneId = this.getProperty("zoneId", "UTC");
        boolean addMeta = this.getPropertyAsBoolean("addMeta", false);
        Long maxRows = this.getPropertyAsInteger("maxRows", Long.MAX_VALUE);
        Connection conn = null;
        Statement stmt = null;
        try {
            Class.forName(jdbcDriver);
            conn = DriverManager.getConnection(jdbcUrl, user, password);
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int columnCount = rs.getMetaData().getColumnCount();
            long rowNumber = 0L;
            while (rs.next() && rowNumber < maxRows) {
                ++rowNumber;
                Document document = new Document();
                for (int i = 1; i <= columnCount; ++i) {
                    String key = rs.getMetaData().getColumnLabel(i);
                    String value = rs.getString(i);
                    String datatype = rs.getMetaData().getColumnClassName(i);
                    if (datatype.equals("java.sql.Timestamp") && value != null) {
                        value = DateUtils.timestamp2String(rs.getTimestamp(i), zoneId);
                    }
                    if (value == null) continue;
                    document.addField(key, value);
                }
                if (addMeta) {
                    document.addField("rowNumber", String.valueOf(rowNumber));
                }
                this.executer.document(document);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException se) {
            throw new RuntimeException(se);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se2) {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException se) {
                    throw new RuntimeException(se);
                }
            }
        }
    }
}

