/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.google.common.base.Strings;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.pipeline.filter.SimpleMapping;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonPathReader
extends AbstractReader {
    private Map<String, List<String>> mapping;
    private String rootPath;

    @Override
    public void read() {
        SimpleMapping simpleMapping = new SimpleMapping(this.getPropertyAsList("mapping", new ArrayList<String>()), this.getPropertyAsList("config", new ArrayList<String>()));
        this.mapping = simpleMapping.getMapping();
        try {
            this.rootPath = this.getProperty("rootPath", "$");
            String url = this.getProperty("url", null);
            String path = this.getProperty("path", null);
            String filename = this.getProperty("filename", null);
            String json = this.getProperty("json", null);
            if (!Strings.isNullOrEmpty((String)url)) {
                DocumentContext context = this.loadJsonContextFromUrl(url);
                this.execute(context, url);
            } else if (!Strings.isNullOrEmpty((String)filename)) {
                File jsonFile = IOUtils.getAbsoluteFileAsFile(this.getBaseDir(), filename);
                DocumentContext context = this.loadJsonContextFromFile(jsonFile);
                this.execute(context, filename);
            } else if (!Strings.isNullOrEmpty((String)json)) {
                DocumentContext context = this.loadJsonContextFromJson(json);
                this.execute(context, filename);
            } else if (!Strings.isNullOrEmpty((String)path)) {
                String absolutePath = IOUtils.getAbsoluteFile(this.getBaseDir(), path);
                List<String> absoluteJsonFiles = IOUtils.getFiles(absolutePath);
                for (String absoluteJsonFile : absoluteJsonFiles) {
                    File file = new File(absoluteJsonFile);
                    DocumentContext context = this.loadJsonContextFromFile(new File(absoluteJsonFile));
                    this.execute(context, file.getName());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void execute(DocumentContext context, String source) {
        List jsonHits = (List)context.read(this.rootPath, new Predicate[0]);
        for (Object obj : jsonHits) {
            Document document = new Document();
            DocumentContext documentContext = JsonPath.parse(obj);
            for (Map.Entry<String, List<String>> mappingEntry : this.mapping.entrySet()) {
                try {
                    Object parsedValue = documentContext.read(mappingEntry.getKey(), new Predicate[0]);
                    for (String target : mappingEntry.getValue()) {
                        document.setField(target, parsedValue);
                    }
                }
                catch (PathNotFoundException pathNotFoundException) {
                }
            }
            document.addField("source", source);
            this.executer.document(document);
        }
    }

    protected DocumentContext loadJsonContextFromUrl(String url) throws IOException {
        String jsonBody = HTTPHelper.get(url);
        DocumentContext context = JsonPath.parse((String)jsonBody);
        return context;
    }

    protected DocumentContext loadJsonContextFromFile(File jsonFile) throws IOException {
        DocumentContext context = JsonPath.parse((File)jsonFile);
        return context;
    }

    protected DocumentContext loadJsonContextFromJson(String jsonString) throws IOException {
        DocumentContext context = JsonPath.parse((String)jsonString);
        return context;
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void end() {
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

