/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.DocumentBuilder;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.FileUtils;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonSurfer;
import org.jsfr.json.JsonSurferGson;
import org.jsfr.json.ParsingContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsonReader
extends AbstractReader {
    private ScriptEngine engine;
    private String script;
    private String filename;
    private Context cx;
    private String javaScriptFilename;
    private String rootPath;

    @Override
    public void read() {
        try {
            ScriptEngineManager mgr = new ScriptEngineManager();
            this.engine = mgr.getEngineByName("JavaScript");
            String internalFilename = this.getProperty("filename", null);
            this.filename = IOUtils.getAbsoluteFile(this.getBaseDir(), internalFilename);
            String internalJavaScriptFilename = this.getProperty("javaScriptFilename", null);
            this.javaScriptFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), internalJavaScriptFilename);
            this.rootPath = this.getProperty("rootPath", "$");
            this.script = FileUtils.readFileToString((File)new File(this.javaScriptFilename));
            this.cx = Context.enter();
            JsonSurfer surfer = JsonSurferGson.INSTANCE;
            FileReader sample = new FileReader(this.filename);
            surfer.configBuilder().bind(this.rootPath, new JsonPathListener[]{new JsonPathListener(){

                public void onValue(Object value, ParsingContext context) {
                    ScriptableObject scope = JsonReader.this.cx.initStandardObjects();
                    ArrayList output = new ArrayList();
                    ScriptableObject.putProperty((Scriptable)scope, (String)"documentBuilder", (Object)Context.javaToJS((Object)new DocumentBuilder(), (Scriptable)scope));
                    ScriptableObject.putProperty((Scriptable)scope, (String)"output", (Object)Context.javaToJS(output, (Scriptable)scope));
                    String exec = "var input = " + value.toString() + ";" + JsonReader.this.script;
                    JsonReader.this.cx.evaluateString((Scriptable)scope, exec, JsonReader.this.filename, 1, null);
                    for (Document out : output) {
                        JsonReader.this.executer.document(out);
                    }
                }
            }}).buildAndSurf((java.io.Reader)sample);
            ((java.io.Reader)sample).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void end() {
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

