/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.filter.LookupFilter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lookup {
    private static Logger LOG = LoggerFactory.getLogger(Lookup.class);
    private Map<String, Document> lookupMap;
    private String pipeline;
    private LookupFilter lookupFilter;

    public Lookup(String pipeline) {
        this.pipeline = pipeline;
    }

    void init() {
        PipelineExecuter pipelineExecuter = new PipelineExecuter(this.pipeline);
        pipelineExecuter.execute();
        this.lookupFilter = (LookupFilter)pipelineExecuter.getFilterById("lookup");
        this.lookupMap = this.lookupFilter.getLookup();
    }

    public Document get(String key) {
        if (this.lookupMap == null) {
            this.init();
        }
        String normalizedKey = this.lookupFilter.normalizeKey(key);
        LOG.info("--------------- " + normalizedKey);
        return this.lookupMap.get(normalizedKey);
    }
}

