/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class NetbaseReader
extends AbstractReader {
    @Override
    public void read() {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        try {
            String url = this.getProperty("url", null);
            String filename = this.getProperty("filename", null);
            if (filename != null) {
                String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
                this.processFile(absoluteFilename, gson);
            } else {
                this.processUrl(url, gson);
            }
            List<String> netbaseIds = this.getPropertyAsList("netbaseIds", new ArrayList<String>());
            for (String netbaseId : netbaseIds) {
                String netBaseUrl = url + netbaseId + "+limit+100000";
                String response = HTTPHelper.get(netBaseUrl);
                this.processBatch(gson, response);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processUrl(String url, Gson gson) {
        List<String> netbaseIds = this.getPropertyAsList("netbaseIds", new ArrayList<String>());
        for (String netbaseId : netbaseIds) {
            String netBaseUrl = url + netbaseId + "+limit+100000";
            String response = HTTPHelper.get(netBaseUrl);
            this.processBatch(gson, response);
        }
    }

    private void processFile(String filename, Gson gson) throws IOException {
        String response = FileUtils.readFileToString((File)new File(filename));
        this.processBatch(gson, response);
    }

    private void processBatch(Gson gson, String response) {
        JsonElement jsonResponse = (JsonElement)gson.fromJson(response, JsonElement.class);
        Iterator hitsIterator = jsonResponse.getAsJsonObject().get("results").getAsJsonArray().get(0).getAsJsonObject().get("statements").getAsJsonArray().iterator();
        while (hitsIterator.hasNext()) {
            Document document = new Document();
            for (Map.Entry entry : ((JsonElement)hitsIterator.next()).getAsJsonObject().entrySet()) {
                if (((JsonElement)entry.getValue()).isJsonArray() || !((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                document.addField((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            this.executer.document(document);
        }
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

