/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class OpenThesaurusReader
extends AbstractReader {
    private String processingOption;

    @Override
    public void read() {
        this.processingOption = this.getProperty("processingOption", "line2Document");
        String fileName = this.getProperty("fileName", null);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] lineParts = line.split(Pattern.quote(";"));
                if ("line2Document".equals(this.processingOption)) {
                    this.line2document(lineParts);
                    continue;
                }
                if ("token2document".equals(this.processingOption)) {
                    this.token2document(lineParts);
                    continue;
                }
                throw new RuntimeException("You have to configure a correct processingOption [line2Document, token2document] . processingOption: " + this.processingOption);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void line2document(String[] lineParts) {
        Document document = new Document();
        document.setField("tokens", Arrays.asList(lineParts));
        this.executer.document(document);
    }

    void token2document(String[] lineParts) {
        for (String token : lineParts) {
            Document document = new Document();
            document.setField("token", token);
            this.executer.document(document);
        }
    }
}

