/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.google.common.base.Strings;
import com.quasiris.qsc.writer.QscDataPushWriter;
import de.tblsoft.solr.compare.SolrCompareFilter;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.CSVReader;
import de.tblsoft.solr.pipeline.DocumentGeneratorReader;
import de.tblsoft.solr.pipeline.DocumentReader;
import de.tblsoft.solr.pipeline.DocumentWriter;
import de.tblsoft.solr.pipeline.ElasticJsonPathReader;
import de.tblsoft.solr.pipeline.ElasticReader;
import de.tblsoft.solr.pipeline.ElasticdumpJsonReader;
import de.tblsoft.solr.pipeline.FileLineWriter;
import de.tblsoft.solr.pipeline.FilelineReader;
import de.tblsoft.solr.pipeline.FilterIF;
import de.tblsoft.solr.pipeline.GCLogReader;
import de.tblsoft.solr.pipeline.GraphQLReader;
import de.tblsoft.solr.pipeline.GrokReader;
import de.tblsoft.solr.pipeline.HtmlFileReader;
import de.tblsoft.solr.pipeline.JdbcReader;
import de.tblsoft.solr.pipeline.JsonPathReader;
import de.tblsoft.solr.pipeline.JsonReader;
import de.tblsoft.solr.pipeline.NetbaseReader;
import de.tblsoft.solr.pipeline.OpenThesaurusReader;
import de.tblsoft.solr.pipeline.ProcessorIF;
import de.tblsoft.solr.pipeline.QSFDataReader;
import de.tblsoft.solr.pipeline.RandomReader;
import de.tblsoft.solr.pipeline.ReaderIF;
import de.tblsoft.solr.pipeline.SolrQueryLogReader;
import de.tblsoft.solr.pipeline.StandardReader;
import de.tblsoft.solr.pipeline.ThreadDumpReader;
import de.tblsoft.solr.pipeline.XmlReader;
import de.tblsoft.solr.pipeline.XmlSitemapReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Filter;
import de.tblsoft.solr.pipeline.bean.Pipeline;
import de.tblsoft.solr.pipeline.bean.Processor;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.pipeline.filter.AddStaticValueFilter;
import de.tblsoft.solr.pipeline.filter.AggregationCountFilter;
import de.tblsoft.solr.pipeline.filter.BeanShellFilter;
import de.tblsoft.solr.pipeline.filter.BlacklistFieldFilter;
import de.tblsoft.solr.pipeline.filter.BlacklistTopicFilter;
import de.tblsoft.solr.pipeline.filter.CSVWriter;
import de.tblsoft.solr.pipeline.filter.CharCounterFilter;
import de.tblsoft.solr.pipeline.filter.CompoundWordFilter;
import de.tblsoft.solr.pipeline.filter.DateFilter;
import de.tblsoft.solr.pipeline.filter.DictionaryNormalizationFilter;
import de.tblsoft.solr.pipeline.filter.DocumentJoinerFilter;
import de.tblsoft.solr.pipeline.filter.DuplicateRemovalFilter;
import de.tblsoft.solr.pipeline.filter.ElasticWriter;
import de.tblsoft.solr.pipeline.filter.ElasticdumpFileWriter;
import de.tblsoft.solr.pipeline.filter.EmptyArrayValuesFilter;
import de.tblsoft.solr.pipeline.filter.EmptyFieldDocumentFilter;
import de.tblsoft.solr.pipeline.filter.EncodingCorrectionFilter;
import de.tblsoft.solr.pipeline.filter.EntityExtractionFilter;
import de.tblsoft.solr.pipeline.filter.ExcludeByValueFilter;
import de.tblsoft.solr.pipeline.filter.ExpectedDocumentCountFilter;
import de.tblsoft.solr.pipeline.filter.FieldJoiner;
import de.tblsoft.solr.pipeline.filter.FieldSplitter;
import de.tblsoft.solr.pipeline.filter.FileMathFilter;
import de.tblsoft.solr.pipeline.filter.ForkDocumentFilter;
import de.tblsoft.solr.pipeline.filter.GrepFilter;
import de.tblsoft.solr.pipeline.filter.HtmlFilter;
import de.tblsoft.solr.pipeline.filter.HtmlJsoupFilter;
import de.tblsoft.solr.pipeline.filter.HtmlTextExtractorFilter;
import de.tblsoft.solr.pipeline.filter.HttpFilter;
import de.tblsoft.solr.pipeline.filter.IgnoreDocumentFilter;
import de.tblsoft.solr.pipeline.filter.JavaScriptFilter;
import de.tblsoft.solr.pipeline.filter.JsonWriter;
import de.tblsoft.solr.pipeline.filter.KafkaWriter;
import de.tblsoft.solr.pipeline.filter.KeyValueSplitterFilter;
import de.tblsoft.solr.pipeline.filter.LastFilter;
import de.tblsoft.solr.pipeline.filter.LibSvmWriter;
import de.tblsoft.solr.pipeline.filter.LinkCheckerFilter;
import de.tblsoft.solr.pipeline.filter.LookupFilter;
import de.tblsoft.solr.pipeline.filter.LowercaseFilter;
import de.tblsoft.solr.pipeline.filter.MappingFilter;
import de.tblsoft.solr.pipeline.filter.MessageDigestFilter;
import de.tblsoft.solr.pipeline.filter.Multivalue2DocumentFilter;
import de.tblsoft.solr.pipeline.filter.N3Writer;
import de.tblsoft.solr.pipeline.filter.NoopFilter;
import de.tblsoft.solr.pipeline.filter.NounExtractorFilter;
import de.tblsoft.solr.pipeline.filter.OffsetPermutationFilter;
import de.tblsoft.solr.pipeline.filter.OpenNlpPosTagFilter;
import de.tblsoft.solr.pipeline.filter.OpenNlpPosTagWriteTrainingFilter;
import de.tblsoft.solr.pipeline.filter.ProcessingTimeFilter;
import de.tblsoft.solr.pipeline.filter.RandomStaticValueFilter;
import de.tblsoft.solr.pipeline.filter.RegexFindFilter;
import de.tblsoft.solr.pipeline.filter.RegexReplaceFilter;
import de.tblsoft.solr.pipeline.filter.RegexSplitFilter;
import de.tblsoft.solr.pipeline.filter.RemoveFieldFilter;
import de.tblsoft.solr.pipeline.filter.RemoveHtmlFilter;
import de.tblsoft.solr.pipeline.filter.RestFilter;
import de.tblsoft.solr.pipeline.filter.RichJavaScriptFilter;
import de.tblsoft.solr.pipeline.filter.RoundNumberFilter;
import de.tblsoft.solr.pipeline.filter.ShingleFilter;
import de.tblsoft.solr.pipeline.filter.SimpleGenderFilter;
import de.tblsoft.solr.pipeline.filter.SleepFilter;
import de.tblsoft.solr.pipeline.filter.SolrFeeder;
import de.tblsoft.solr.pipeline.filter.SolrNumFoundFilter;
import de.tblsoft.solr.pipeline.filter.SplashFilter;
import de.tblsoft.solr.pipeline.filter.SpyFilter;
import de.tblsoft.solr.pipeline.filter.StatisticFilter;
import de.tblsoft.solr.pipeline.filter.StatusFilter;
import de.tblsoft.solr.pipeline.filter.StatusTimeFilter;
import de.tblsoft.solr.pipeline.filter.StopwordFilter;
import de.tblsoft.solr.pipeline.filter.SystemOutWriter;
import de.tblsoft.solr.pipeline.filter.TestingFilter;
import de.tblsoft.solr.pipeline.filter.TokenCounterFilter;
import de.tblsoft.solr.pipeline.filter.TokenPermutationFilter;
import de.tblsoft.solr.pipeline.filter.TokenizerFilter;
import de.tblsoft.solr.pipeline.filter.TopicAggregationFilter;
import de.tblsoft.solr.pipeline.filter.TopicMergeFilter;
import de.tblsoft.solr.pipeline.filter.UrlSplitter;
import de.tblsoft.solr.pipeline.filter.ValidationFilter;
import de.tblsoft.solr.pipeline.filter.ValueMappingFilter;
import de.tblsoft.solr.pipeline.filter.WhitelistTopicTermsFilter;
import de.tblsoft.solr.pipeline.filter.XmlSitemapWriter;
import de.tblsoft.solr.pipeline.filter.nlp.SearchQueryAnalyzerFilter;
import de.tblsoft.solr.pipeline.nlp.squad.SquadReader;
import de.tblsoft.solr.pipeline.nlp.squad.SquadWriter;
import de.tblsoft.solr.pipeline.processor.DownloadResourcesProcessor;
import de.tblsoft.solr.pipeline.processor.Json2SingleDocumentsProcessor;
import de.tblsoft.solr.pipeline.processor.NoopProcessor;
import de.tblsoft.solr.pipeline.processor.OpenNLPPosTaggerTrainProcessor;
import de.tblsoft.solr.pipeline.processor.QSFDataRepositoryUploadProcessor;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class PipelineExecuter
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(PipelineExecuter.class);
    private Pipeline pipeline;
    private String baseDir;
    private Map<String, Pipeline> pipelineMap = new HashMap<String, Pipeline>();
    private String webHookStart;
    private String webHookEnd;
    private String webHookError;
    private List<ProcessorIF> preProcessorList;
    private List<FilterIF> filterList;
    private List<ProcessorIF> postProcessorList;
    private ReaderIF reader;
    private String yamlFileName;
    private Map<String, String> pipelineVariables = new HashMap<String, String>();
    private String processId;
    private Long expectedDocumentCount = -1L;
    private static Map<String, Class> classRegestriy = new HashMap<String, Class>();

    public PipelineExecuter(String yamlFileName) {
        this.yamlFileName = yamlFileName;
    }

    public PipelineExecuter(Pipeline pipeline, String baseDir) {
        this.pipeline = pipeline;
        this.baseDir = baseDir;
    }

    private String getBaseDirFromYamlFile() {
        if (this.yamlFileName.startsWith("http")) {
            try {
                URI uri = new URI(this.yamlFileName);
                return uri.resolve(".").toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        File f = new File(this.yamlFileName).getAbsoluteFile();
        return f.getParentFile().getAbsoluteFile().toString();
    }

    public void init() {
        try {
            if (this.pipeline == null) {
                LOG.debug("Read the pipeline configuration from the yaml file: {}", (Object)this.yamlFileName);
                List<Pipeline> pipelines = PipelineExecuter.readPipelinesFromYamlFile(this.yamlFileName);
                for (Pipeline p : pipelines) {
                    if (this.pipeline == null) {
                        this.pipeline = p;
                    }
                    if (p.getId() == null) continue;
                    this.pipelineMap.put(p.getId(), p);
                }
            }
            if (this.baseDir == null) {
                this.baseDir = this.getBaseDirFromYamlFile();
            }
            this.processId = this.pipeline.getProcessId();
            if (Strings.isNullOrEmpty((String)this.processId)) {
                this.processId = UUID.randomUUID().toString();
            }
            this.webHookStart = this.pipeline.getWebHookStart();
            this.webHookEnd = this.pipeline.getWebHookEnd();
            this.webHookError = this.pipeline.getWebHookError();
            HTTPHelper.webHook(this.webHookStart, "status", "start", "processId", this.processId);
            LOG.debug("processId {}", (Object)this.processId);
            LOG.debug("Default variables in the pipeline {}", this.pipeline.getVariables());
            LOG.debug("Configured variables in the pipeline {}", this.pipelineVariables);
            File settingsPropertiesFile = new File(FileUtils.getUserDirectory().getAbsolutePath() + "/.solr-cmd-utils/settings.properties");
            if (settingsPropertiesFile.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(settingsPropertiesFile));
                HashMap settings = new HashMap();
                prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> settings.put(key.toString(), value.toString())));
                this.pipeline.getVariables().putAll(settings);
            }
            this.pipeline.getVariables().putAll(this.pipelineVariables);
            LOG.debug("Effective variables in the pipeline {}", this.pipeline.getVariables());
            this.reader = PipelineExecuter.createReaderInstance(this.pipeline.getReader(), this.baseDir, this.pipeline.getVariables(), this);
            this.preProcessorList = this.createProcessorInstanceList(this.pipeline.getPreProcessor());
            this.postProcessorList = this.createProcessorInstanceList(this.pipeline.getPostProcessor());
            this.filterList = this.createFilterInstanceList();
            this.createFilterInstanceList();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private List<FilterIF> createFilterInstanceList() {
        ArrayList<FilterIF> filterInstanceList = new ArrayList<FilterIF>();
        if (this.pipeline.getFilter() == null) {
            return filterInstanceList;
        }
        FilterIF lastFilter = null;
        FilterIF filterInstance = null;
        for (Filter filter : this.pipeline.getFilter()) {
            if (filter.getDisabled() != null && filter.getDisabled().booleanValue()) continue;
            filterInstance = PipelineExecuter.createFilterInstance(filter);
            filterInstance.setBaseDir(this.baseDir);
            filterInstance.setVariables(this.pipeline.getVariables());
            filterInstance.setPipelineExecuter(this);
            if (lastFilter == null) {
                lastFilter = filterInstance;
                continue;
            }
            lastFilter.setNextFilter(filterInstance);
            filterInstanceList.add(lastFilter);
            lastFilter = filterInstance;
        }
        filterInstance.setNextFilter(new LastFilter());
        filterInstanceList.add(filterInstance);
        return filterInstanceList;
    }

    public static ReaderIF createReaderInstance(Reader reader, String baseDir, Map<String, String> variables, PipelineExecuter pipelineExecuter) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (reader == null) {
            return null;
        }
        ReaderIF readerInstance = (ReaderIF)PipelineExecuter.getInstance(reader.getClazz());
        readerInstance.setPipelineExecuter(pipelineExecuter);
        readerInstance.setReader(reader);
        readerInstance.setBaseDir(baseDir);
        readerInstance.setVariables(variables);
        return readerInstance;
    }

    private List<ProcessorIF> createProcessorInstanceList(List<Processor> processorList) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList<ProcessorIF> processorInstanceList = new ArrayList<ProcessorIF>();
        if (processorList == null) {
            return processorInstanceList;
        }
        for (Processor processor : processorList) {
            if (processor.getDisabled().booleanValue()) continue;
            ProcessorIF processorInstance = (ProcessorIF)PipelineExecuter.getInstance(processor.getClazz());
            processorInstance.setProcessor(processor);
            processorInstance.setVariables(this.pipeline.getVariables());
            processorInstance.setBaseDir(this.baseDir);
            processorInstanceList.add(processorInstance);
        }
        return processorInstanceList;
    }

    public static Object getInstance(String clazz) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class clazzClass = classRegestriy.get(clazz);
        if (clazzClass != null) {
            return Class.forName(clazzClass.getName()).newInstance();
        }
        return Class.forName(clazz).newInstance();
    }

    public static FilterIF createFilterInstance(Filter filter) {
        try {
            String filterClazz = filter.getClazz();
            FilterIF filterInstance = (FilterIF)PipelineExecuter.getInstance(filterClazz);
            filterInstance.setFilterConfig(filter);
            return filterInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void execute(String yamlFileName) {
        PipelineExecuter pipelineExecuter = new PipelineExecuter(yamlFileName);
        pipelineExecuter.execute();
    }

    public void execute() {
        try {
            LOG.debug("Start the initialization.");
            this.init();
            LOG.debug("Process the pre processors.");
            for (ProcessorIF processorIF : this.preProcessorList) {
                processorIF.process();
            }
            if (this.reader != null) {
                LOG.debug("Start the initialization for all filters.");
                if (this.filterList.size() > 0) {
                    this.filterList.get(0).init();
                }
                LOG.debug("Read the input from the configured reader.");
                this.reader.read();
                LOG.debug("Finalize the pipeline.");
                this.end();
            }
            LOG.debug("Process the post processors.");
            for (ProcessorIF processorIF : this.postProcessorList) {
                processorIF.process();
            }
            HTTPHelper.webHook(this.webHookEnd, "status", "end", "processId", this.processId);
        }
        catch (Exception e) {
            this.onWebhookError(e);
            throw e;
        }
    }

    private void onWebhookError(Exception exception) {
        if (!Strings.isNullOrEmpty((String)this.webHookError)) {
            try {
                String exceptionString = ExceptionUtils.getStackTrace((Throwable)exception);
                HTTPHelper.post(this.webHookError, exceptionString);
            }
            catch (Exception e) {
                LOG.error("Could not call the error webHookError {} because {}", new Object[]{this.webHookError, e.getMessage(), e});
            }
        }
    }

    public void document(Document document) {
        this.filterList.get(0).document(document);
    }

    public void end() {
        this.reader.end();
        this.filterList.get(0).end();
    }

    @Deprecated
    public static Pipeline readPipelineFromYamlFile(String fileName) {
        try {
            List<Pipeline> pipelines = PipelineExecuter.readPipelinesFromYamlFile(fileName);
            if (pipelines == null || pipelines.size() == 0) {
                return null;
            }
            return pipelines.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Pipeline> readPipelinesFromYamlFile(String fileName) {
        try {
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(Pipeline.class));
            String pipelineString = IOUtils.getString(fileName);
            LOG.info("pipeline:\n" + pipelineString);
            Iterable pipelines = yaml.loadAll(pipelineString);
            ArrayList<Pipeline> ret = new ArrayList<Pipeline>();
            for (Object obj : pipelines) {
                ret.add((Pipeline)obj);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<FilterIF> getFilterList() {
        return this.filterList;
    }

    public FilterIF getFilterById(String filterId) {
        for (FilterIF filter : this.getFilterList()) {
            if (!filterId.equals(filter.getId())) continue;
            return filter;
        }
        throw new IllegalArgumentException("The filter with the id: " + filterId + " does not exists.");
    }

    public ReaderIF getReader() {
        return this.reader;
    }

    public Map<String, String> getPipelineVariables() {
        return this.pipelineVariables;
    }

    public void setPipelineVariables(Map<String, String> pipelineVariables) {
        this.pipelineVariables = pipelineVariables;
    }

    public void addPipelineVariable(String name, String value) {
        this.pipelineVariables.put(name, value);
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Long getExpectedDocumentCount() {
        return this.expectedDocumentCount;
    }

    public void setExpectedDocumentCount(Long expectedDocumentCount) {
        this.expectedDocumentCount = expectedDocumentCount;
    }

    public Pipeline getPipeline(String id) {
        return this.pipelineMap.get(id);
    }

    static {
        classRegestriy.put("solrcmdutils.DownloadResourcesProcessor", DownloadResourcesProcessor.class);
        classRegestriy.put("solrcmdutils.StandardReader", StandardReader.class);
        classRegestriy.put("solrcmdutils.QSFDataReader", QSFDataReader.class);
        classRegestriy.put("solrcmdutils.RandomReader", RandomReader.class);
        classRegestriy.put("solrcmdutils.GrokReader", GrokReader.class);
        classRegestriy.put("solrcmdutils.GCLogReader", GCLogReader.class);
        classRegestriy.put("solrcmdutils.JsonPathReader", JsonPathReader.class);
        classRegestriy.put("solrcmdutils.JsonReader", JsonReader.class);
        classRegestriy.put("solrcmdutils.ElasticJsonPathReader", ElasticJsonPathReader.class);
        classRegestriy.put("solrcmdutils.ElasticReader", ElasticReader.class);
        classRegestriy.put("solrcmdutils.XmlReader", XmlReader.class);
        classRegestriy.put("solrcmdutils.XmlSitemapReader", XmlSitemapReader.class);
        classRegestriy.put("solrcmdutils.XmlSitemapWriter", XmlSitemapWriter.class);
        classRegestriy.put("solrcmdutils.HttpFilter", HttpFilter.class);
        classRegestriy.put("solrcmdutils.SplashFilter", SplashFilter.class);
        classRegestriy.put("solrcmdutils.HtmlJsoupFilter", HtmlJsoupFilter.class);
        classRegestriy.put("solrcmdutils.HtmlFilter", HtmlFilter.class);
        classRegestriy.put("solrcmdutils.EntityExtractionFilter", EntityExtractionFilter.class);
        classRegestriy.put("solrcmdutils.ValidationFilter", ValidationFilter.class);
        classRegestriy.put("solrcmdutils.OpenThesaurusReader", OpenThesaurusReader.class);
        classRegestriy.put("solrcmdutils.DictionaryNormalizationFilter", DictionaryNormalizationFilter.class);
        classRegestriy.put("solrcmdutils.ThreadDumpReader", ThreadDumpReader.class);
        classRegestriy.put("solrcmdutils.DateFilter", DateFilter.class);
        classRegestriy.put("solrcmdutils.ProcessingTimeFilter", ProcessingTimeFilter.class);
        classRegestriy.put("solrcmdutils.UrlSplitter", UrlSplitter.class);
        classRegestriy.put("solrcmdutils.GrepFilter", GrepFilter.class);
        classRegestriy.put("solrcmdutils.KeyValueSplitterFilter", KeyValueSplitterFilter.class);
        classRegestriy.put("solrcmdutils.FieldJoiner", FieldJoiner.class);
        classRegestriy.put("solrcmdutils.DocumentJoinerFilter", DocumentJoinerFilter.class);
        classRegestriy.put("solrcmdutils.JsonWriter", JsonWriter.class);
        classRegestriy.put("solrcmdutils.ElasticWriter", ElasticWriter.class);
        classRegestriy.put("solrcmdutils.CSVReader", CSVReader.class);
        classRegestriy.put("solrcmdutils.JdbcReader", JdbcReader.class);
        classRegestriy.put("solrcmdutils.SolrQueryLogReader", SolrQueryLogReader.class);
        classRegestriy.put("solrcmdutils.SpyFilter", SpyFilter.class);
        classRegestriy.put("solrcmdutils.StatusFilter", StatusFilter.class);
        classRegestriy.put("solrcmdutils.StatusTimeFilter", StatusTimeFilter.class);
        classRegestriy.put("solrcmdutils.ExpectedDocumentCountFilter", ExpectedDocumentCountFilter.class);
        classRegestriy.put("solrcmdutils.StatisticFilter", StatisticFilter.class);
        classRegestriy.put("solrcmdutils.MappingFilter", MappingFilter.class);
        classRegestriy.put("solrcmdutils.ValueMappingFilter", ValueMappingFilter.class);
        classRegestriy.put("solrcmdutils.EncodingCorrectionFilter", EncodingCorrectionFilter.class);
        classRegestriy.put("solrcmdutils.RegexSplitFilter", RegexSplitFilter.class);
        classRegestriy.put("solrcmdutils.RegexFindFilter", RegexFindFilter.class);
        classRegestriy.put("solrcmdutils.FieldSplitter", FieldSplitter.class);
        classRegestriy.put("solrcmdutils.Multivalue2DocumentFilter", Multivalue2DocumentFilter.class);
        classRegestriy.put("solrcmdutils.IgnoreDocumentFilter", IgnoreDocumentFilter.class);
        classRegestriy.put("solrcmdutils.BeanShellFilter", BeanShellFilter.class);
        classRegestriy.put("solrcmdutils.LookupFilter", LookupFilter.class);
        classRegestriy.put("solrcmdutils.TokenCounterFilter", TokenCounterFilter.class);
        classRegestriy.put("solrcmdutils.TokenizerFilter", TokenizerFilter.class);
        classRegestriy.put("solrcmdutils.LowercaseFilter", LowercaseFilter.class);
        classRegestriy.put("solrcmdutils.ShingleFilter", ShingleFilter.class);
        classRegestriy.put("solrcmdutils.RemoveHtmlFilter", RemoveHtmlFilter.class);
        classRegestriy.put("solrcmdutils.CharCounterFilter", CharCounterFilter.class);
        classRegestriy.put("solrcmdutils.CompoundWordFilter", CompoundWordFilter.class);
        classRegestriy.put("solrcmdutils.LinkCheckerFilter", LinkCheckerFilter.class);
        classRegestriy.put("solrcmdutils.SolrFeeder", SolrFeeder.class);
        classRegestriy.put("solrcmdutils.SolrNumFoundFilter", SolrNumFoundFilter.class);
        classRegestriy.put("solrcmdutils.SolrCompareFilter", SolrCompareFilter.class);
        classRegestriy.put("solrcmdutils.SystemOutWriter", SystemOutWriter.class);
        classRegestriy.put("solrcmdutils.NounExtractorFilter", NounExtractorFilter.class);
        classRegestriy.put("solrcmdutils.FileLineWriter", FileLineWriter.class);
        classRegestriy.put("solrcmdutils.FilelineReader", FilelineReader.class);
        classRegestriy.put("solrcmdutils.HtmlFileReader", HtmlFileReader.class);
        classRegestriy.put("solrcmdutils.CSVWriter", CSVWriter.class);
        classRegestriy.put("solrcmdutils.N3Writer", N3Writer.class);
        classRegestriy.put("solrcmdutils.KafkaWriter", KafkaWriter.class);
        classRegestriy.put("solrcmdutils.TestingFilter", TestingFilter.class);
        classRegestriy.put("solrcmdutils.NoopFilter", NoopFilter.class);
        classRegestriy.put("solrcmdutils.DuplicateRemovalFilter", DuplicateRemovalFilter.class);
        classRegestriy.put("solrcmdutils.ForkDocumentFilter", ForkDocumentFilter.class);
        classRegestriy.put("solrcmdutils.NetbaseReader", NetbaseReader.class);
        classRegestriy.put("solrcmdutils.BlacklistTopicFilter", BlacklistTopicFilter.class);
        classRegestriy.put("solrcmdutils.BlacklistFieldFilter", BlacklistFieldFilter.class);
        classRegestriy.put("solrcmdutils.WhitelistTopicTermsFilter", WhitelistTopicTermsFilter.class);
        classRegestriy.put("solrcmdutils.TopicMergeFilter", TopicMergeFilter.class);
        classRegestriy.put("solrcmdutils.TopicAggregationFilter", TopicAggregationFilter.class);
        classRegestriy.put("solrcmdutils.AggregationCountFilter", AggregationCountFilter.class);
        classRegestriy.put("solrcmdutils.ElasticdumpFileWriter", ElasticdumpFileWriter.class);
        classRegestriy.put("solrcmdutils.DocumentGeneratorReader", DocumentGeneratorReader.class);
        classRegestriy.put("solrcmdutils.JavaScriptFilter", JavaScriptFilter.class);
        classRegestriy.put("solrcmdutils.RichJavaScriptFilter", RichJavaScriptFilter.class);
        classRegestriy.put("solrcmdutils.SimpleGenderFilter", SimpleGenderFilter.class);
        classRegestriy.put("solrcmdutils.RegexReplaceFilter", RegexReplaceFilter.class);
        classRegestriy.put("solrcmdutils.EmptyFieldDocumentFilter", EmptyFieldDocumentFilter.class);
        classRegestriy.put("solrcmdutils.EmptyArrayValuesFilter", EmptyArrayValuesFilter.class);
        classRegestriy.put("solrcmdutils.FileMathFilter", FileMathFilter.class);
        classRegestriy.put("solrcmdutils.RoundNumberFilter", RoundNumberFilter.class);
        classRegestriy.put("solrcmdutils.LibSvmWriter", LibSvmWriter.class);
        classRegestriy.put("solrcmdutils.ElasticdumpJsonReader", ElasticdumpJsonReader.class);
        classRegestriy.put("solrcmdutils.RemoveFieldFilter", RemoveFieldFilter.class);
        classRegestriy.put("solrcmdutils.MessageDigestFilter", MessageDigestFilter.class);
        classRegestriy.put("solrcmdutils.RandomStaticValueFilter", RandomStaticValueFilter.class);
        classRegestriy.put("solrcmdutils.SleepFilter", SleepFilter.class);
        classRegestriy.put("solrcmdutils.OffsetPermutationFilter", OffsetPermutationFilter.class);
        classRegestriy.put("solrcmdutils.TokenPermutationFilter", TokenPermutationFilter.class);
        classRegestriy.put("solrcmdutils.RestFilter", RestFilter.class);
        classRegestriy.put("solrcmdutils.Json2SingleDocumentsProcessor", Json2SingleDocumentsProcessor.class);
        classRegestriy.put("solrcmdutils.StopwordFilter", StopwordFilter.class);
        classRegestriy.put("solrcmdutils.NoopProcessor", NoopProcessor.class);
        classRegestriy.put("solrcmdutils.QSFDataRepositoryUploadProcessor", QSFDataRepositoryUploadProcessor.class);
        classRegestriy.put("solrcmdutils.HtmlTextExtractorFilter", HtmlTextExtractorFilter.class);
        classRegestriy.put("solrcmdutils.SquadWriter", SquadWriter.class);
        classRegestriy.put("solrcmdutils.SquadReader", SquadReader.class);
        classRegestriy.put("solrcmdutils.OpenNlpPosTagFilter", OpenNlpPosTagFilter.class);
        classRegestriy.put("solrcmdutils.OpenNlpPosTagWriteTrainingFilter", OpenNlpPosTagWriteTrainingFilter.class);
        classRegestriy.put("solrcmdutils.OpenNLPPosTaggerTrainProcessor", OpenNLPPosTaggerTrainProcessor.class);
        classRegestriy.put("solrcmdutils.AddStaticValueFilter", AddStaticValueFilter.class);
        classRegestriy.put("solrcmdutils.ExcludeByValueFilter", ExcludeByValueFilter.class);
        classRegestriy.put("solrcmdutils.DocumentReader", DocumentReader.class);
        classRegestriy.put("solrcmdutils.DocumentWriter", DocumentWriter.class);
        classRegestriy.put("solrcmdutils.SearchQueryAnalyzerFilter", SearchQueryAnalyzerFilter.class);
        classRegestriy.put("solrcmdutils.QscDataPushWriter", QscDataPushWriter.class);
        classRegestriy.put("solrcmdutils.GraphQLReader", GraphQLReader.class);
    }
}

