/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import com.quasiris.qsf.commons.ai.ModelRepositoryManager;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.ReaderIF;
import de.tblsoft.solr.pipeline.bean.Pipeline;
import de.tblsoft.solr.pipeline.bean.Reader;
import java.util.Map;

public class QSFDataReader
extends AbstractReader {
    @Override
    public void read() {
        String groupId = this.getProperty("groupId", null);
        String artifactId = this.getProperty("artifactId", null);
        String version = this.getProperty("version", null);
        String modelBasePath = this.getProperty("modelBasePath", null);
        String modelBaseUrl = this.getProperty("modelBaseUrl", null);
        String pipeline = this.getProperty("pipeline", "pipeline.yml");
        String filenameProperty = this.getProperty("filenameProperty", "filename");
        try {
            ModelRepositoryManager modelRepositoryManager = ModelRepositoryManager.Builder.create().groupId(groupId).artifactId(artifactId).version(version).modelBasePath(modelBasePath).modelBaseUrl(modelBaseUrl).build();
            modelRepositoryManager.install();
            String absolutePipeline = modelRepositoryManager.getAbsoluteModelFile(pipeline);
            Pipeline pipelineInstance = PipelineExecuter.readPipelineFromYamlFile(absolutePipeline);
            Reader reader = pipelineInstance.getReader();
            String filename = (String)reader.getProperty().get(filenameProperty);
            filename = modelRepositoryManager.getAbsoluteModelFile() + filename;
            Map<String, ?> properties = reader.getProperty();
            properties.put(filenameProperty, filename);
            ReaderIF readerInstance = PipelineExecuter.createReaderInstance(reader, "", pipelineInstance.getVariables(), this.executer);
            readerInstance.read();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

