/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.log.parser.SolrLogRow;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class SolrQueryLogReader
extends AbstractReader {
    private Pattern pattern = Pattern.compile(".* \\[(.*)\\] webapp=(.*) path=(.*) params=\\{(.*)\\} hits=(.*) status=(.*) QTime=(.*)");
    private String filename;
    private String currentFileName;
    private String currentDirName;

    @Override
    public void read() {
        this.filename = this.getProperty("filename", null);
        String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), this.filename);
        List<String> fileList = IOUtils.getFiles(absoluteFilename);
        Iterator<String> iterator = fileList.iterator();
        while (iterator.hasNext()) {
            String file;
            this.currentFileName = file = iterator.next();
            this.currentDirName = IOUtils.getDirectoryForFile(file);
            try {
                String line;
                InputStream in = IOUtils.getInputStream(file);
                InputStreamReader isr = new InputStreamReader(in);
                BufferedReader br = new BufferedReader(isr);
                int currentCount = 0;
                Date currentDate = new Date();
                while ((line = br.readLine()) != null) {
                    ++currentCount;
                    Matcher m = this.pattern.matcher(line);
                    if (m.matches()) {
                        try {
                            ++currentCount;
                            SolrLogRow solrLogRow = this.parseRow(line, m, currentDate);
                            this.logRow(solrLogRow);
                        }
                        catch (Exception e) {
                            SolrLogRow item = new SolrLogRow();
                            item.setRaw(line);
                            this.logRowError(item, e);
                        }
                        continue;
                    }
                    currentDate = this.parseDate(line);
                }
                br.close();
            }
            catch (Exception exception) {}
        }
        this.executer.end();
    }

    protected void logRow(SolrLogRow solrLogRow) {
        Document document = new Document();
        document.addField("coreName", solrLogRow.getCoreName());
        document.addField("hits", String.valueOf(solrLogRow.getHits()));
        document.addField("fileName", solrLogRow.getLogFile());
        document.addField("dirName", this.currentDirName);
        document.addField("queryTime", String.valueOf(solrLogRow.getqTime()));
        document.addField("date", this.date2String(solrLogRow.getTimestamp()));
        document.addField("url", solrLogRow.getUrl());
        document.addField("raw", solrLogRow.getRaw());
        this.executer.document(document);
    }

    protected void logRowError(SolrLogRow solrLogRow, Exception e) {
    }

    SolrLogRow parseRow(String line, Matcher m, Date currentDate) {
        SolrLogRow item = new SolrLogRow();
        item.setRaw(line);
        String coreName = m.group(1);
        String webapp = m.group(2);
        String handler = m.group(3);
        String params = m.group(4);
        params = params.replaceAll("\\ ", " ");
        params = params.replaceAll("\\\"", " ");
        int hits = Integer.parseInt(m.group(5));
        int status = Integer.parseInt(m.group(6));
        int qTime = Integer.parseInt(m.group(7).trim());
        List urlParams = URLEncodedUtils.parse((String)params, (Charset)Charset.forName("UTF-8"));
        StringBuilder url = new StringBuilder("http://localhost/?");
        for (NameValuePair pair : urlParams) {
            url.append(pair.getName());
            url.append("=");
            url.append(pair.getValue());
            url.append("&");
        }
        item.setUrl(url.toString());
        item.setCoreName(coreName);
        item.setWebapp(webapp);
        item.setHandler(handler);
        item.setLogFile(this.currentFileName);
        item.setTimestamp(currentDate);
        item.setHits(hits);
        item.setStatus(status);
        item.setqTime(qTime);
        return item;
    }

    String date2String(Date date) {
        SimpleDateFormat sdfPipeline = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return sdfPipeline.format(date);
    }

    protected Date parseDate(String line) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a 'org.apache.solr.core.SolrCore execute'", Locale.US);
        try {
            Date d = sdf.parse(line);
            return d;
        }
        catch (ParseException e) {
            return new Date();
        }
    }
}

