/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import io.thekraken.grok.api.Grok;
import io.thekraken.grok.api.Match;
import io.thekraken.grok.api.exception.GrokException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpReader
extends AbstractReader {
    private static Logger LOG = LoggerFactory.getLogger(ThreadDumpReader.class);
    private boolean isTrace = false;
    private boolean isLockedOwnableSynchronizers = false;
    private StringBuilder traceBuilder = new StringBuilder();
    private String firstTraceLine;
    private String filename;
    private String currentFileName;
    private String currentDirectory;
    private String currentDate;
    private String currentDescription;
    private String runId;
    private String grokPatternPath = "src/main/grok/patterns/patterns";
    private boolean firstThread = true;
    private int position = 0;
    Document currentDocument = new Document();

    @Override
    public void read() {
        this.runId = UUID.randomUUID().toString();
        String relativeFilename = this.getProperty("filename", null);
        this.filename = IOUtils.getAbsoluteFile(this.getBaseDir(), relativeFilename);
        List<String> fileList = IOUtils.getFiles(this.filename);
        for (String file : fileList) {
            try {
                String line;
                this.currentFileName = file;
                this.currentDirectory = IOUtils.getDirectoryForFile(this.currentFileName);
                this.firstThread = true;
                this.position = 0;
                InputStream in = IOUtils.getInputStream(file);
                InputStreamReader isr = new InputStreamReader(in);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (line.matches("^\tat .*")) {
                        this.trace(line);
                        continue;
                    }
                    if (line.matches("^\\d{4}-\\d{2}-\\d{2}.\\d{2}:\\d{2}:\\d{2}$")) {
                        this.date(line);
                        continue;
                    }
                    if (line.matches("^Full thread dump Java HotSpot.*")) {
                        this.description(line);
                        continue;
                    }
                    if (line.matches("^Full thread dump Java HotSpot.*")) {
                        this.description(line);
                        continue;
                    }
                    if (line.matches("^   Locked ownable synchronizers:.*")) {
                        this.lockedOwnableSynchronizers(line);
                        continue;
                    }
                    if (line.matches("^   java.lang.Thread.State.*")) {
                        this.state(line);
                        continue;
                    }
                    if (line.matches("^\t- locked.*")) {
                        this.locked(line);
                        continue;
                    }
                    if (line.matches("^\t- waiting on.*")) {
                        this.waitingOn(line);
                        continue;
                    }
                    if (line.matches("^\t- parking to wait for.*")) {
                        this.parkingToWaitingFor(line);
                        continue;
                    }
                    if (line.matches("^\t-.*")) {
                        this.problem(line);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)line)) {
                        this.emptyLine(line);
                        continue;
                    }
                    if (StringUtils.startsWith((CharSequence)line, (CharSequence)"\"")) {
                        this.thread(line);
                        continue;
                    }
                    if (!StringUtils.startsWith((CharSequence)line, (CharSequence)"JNI global references:")) continue;
                    this.jniReferences(line);
                }
                this.endDocument();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void lockedOwnableSynchronizers(String value) {
        this.isLockedOwnableSynchronizers = true;
    }

    void problem(String value) {
        LOG.info("problem: " + this.isLockedOwnableSynchronizers + " " + value);
    }

    void jniReferences(String jniReferences) {
    }

    void locked(String value) {
    }

    void waitingOn(String value) {
    }

    void parkingToWaitingFor(String value) {
    }

    void date(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdfPipeline = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            Date d = sdf.parse(date);
            this.currentDate = sdfPipeline.format(d);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    void description(String description) {
        this.currentDescription = description;
    }

    void state(String state) {
        state = state.trim().replace("java.lang.Thread.State:", "");
        this.field("state", state);
    }

    void trace(String trace) {
        if (!this.isTrace) {
            this.firstTraceLine = trace;
        }
        this.isTrace = true;
        this.traceBuilder.append(trace);
        this.traceBuilder.append("\n");
    }

    void endTrace() {
        String trace = this.traceBuilder.toString();
        String traceHash = DigestUtils.md5Hex((String)trace);
        this.field("traceHash", traceHash);
        this.field("traceNameHash", this.firstTraceLine + "_" + traceHash);
        this.field("traceName", this.firstTraceLine);
        this.field("trace", trace);
        this.traceBuilder = new StringBuilder();
    }

    private void field(String name, String value) {
        this.currentDocument.addField(name, value);
    }

    void emptyLine(String date) {
        if (this.isTrace) {
            this.isTrace = false;
            this.endTrace();
        }
        if (this.isLockedOwnableSynchronizers) {
            this.isLockedOwnableSynchronizers = false;
            this.endLockedOwnableSynchronizers();
        }
    }

    void endLockedOwnableSynchronizers() {
    }

    void thread(String thread) {
        if (this.firstThread) {
            this.firstThread = false;
        } else {
            this.endDocument();
        }
        Grok grok = null;
        try {
            grok = Grok.create((String)this.grokPatternPath);
            String grokPattern = "%{QUOTEDSTRING:threadname}( %{WORD:deamon})? prio=%{NUMBER:prio} tid=%{NOTSPACE:tid} nid=%{NOTSPACE:nid}";
            grok.compile(grokPattern);
            Match gm = grok.match(thread);
            gm.captures();
            Map m = gm.toMap();
            for (Map.Entry entry : m.entrySet()) {
                Object value = entry.getValue();
                this.field((String)entry.getKey(), String.valueOf(value));
            }
            String nid = (String)m.get("nid");
            nid = nid.replaceFirst("0x", "");
            Integer outputDecimal = Integer.parseInt(nid, 16);
            this.field("threadIdDecimal", String.valueOf(outputDecimal));
        }
        catch (GrokException e) {
            throw new RuntimeException(e);
        }
        this.field("thread", thread);
    }

    void endDocument() {
        this.field("runId", this.runId);
        this.field("description", this.currentDescription);
        this.field("date", this.currentDate);
        this.field("fileName", this.currentFileName);
        this.field("directory", this.currentDirectory);
        this.field("position", String.valueOf(this.position));
        ++this.position;
        this.executer.document(this.currentDocument);
        this.currentDocument = new Document();
    }
}

