/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline;

import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineSaxContentHandler;
import de.tblsoft.solr.util.IOUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.joost.trax.TransformerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlReader
extends AbstractReader {
    private static Logger LOG = LoggerFactory.getLogger(XmlReader.class);

    @Override
    public void read() {
        String currentFileName = null;
        try {
            String deprecatedFilename = this.getProperty("filename", null);
            List<String> filenames = this.getPropertyAsList("filenames", new ArrayList<String>());
            if (deprecatedFilename != null) {
                filenames.add(deprecatedFilename);
            }
            ArrayList<String> fileList = new ArrayList<String>();
            for (String filename : filenames) {
                String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
                fileList.addAll(IOUtils.getFiles(absoluteFilename));
            }
            XMLReader myReader = XMLReaderFactory.createXMLReader();
            PipelineSaxContentHandler mySerializer = new PipelineSaxContentHandler(this.executer);
            boolean firstFile = true;
            TransformerHandler lastHandler = null;
            List<String> transformationFiles = this.getPropertyAsList("transformations", new ArrayList<String>());
            for (String file : transformationFiles) {
                TransformerHandler currentHandler = this.getTransformerHandler(file);
                if (firstFile) {
                    firstFile = false;
                    myReader.setContentHandler(currentHandler);
                    lastHandler = currentHandler;
                    continue;
                }
                lastHandler.setResult(new SAXResult(currentHandler));
                lastHandler = currentHandler;
            }
            if (lastHandler == null) {
                myReader.setContentHandler(mySerializer);
            } else {
                lastHandler.setResult(new SAXResult(mySerializer));
            }
            Iterator<String> iterator = fileList.iterator();
            while (iterator.hasNext()) {
                String sourceFile;
                currentFileName = sourceFile = iterator.next();
                InputStream in = IOUtils.getInputStream(sourceFile);
                myReader.parse(new InputSource(in));
                in.close();
            }
        }
        catch (Exception e) {
            LOG.error("Could not process file: " + currentFileName + " because of: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    TransformerHandler getTransformerHandler(String fileName) throws TransformerConfigurationException {
        fileName = IOUtils.getAbsoluteFile(this.getBaseDir(), fileName);
        if (fileName.endsWith(".stx")) {
            TransformerFactoryImpl stxFactory = new TransformerFactoryImpl();
            return stxFactory.newTransformerHandler(new StreamSource(fileName));
        }
        if (fileName.endsWith(".xsl")) {
            SAXTransformerFactory xslFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            return xslFactory.newTransformerHandler(new StreamSource(fileName));
        }
        throw new IllegalArgumentException("Only the filetypes xsl and stx are supported.");
    }
}

