/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.bean;

import com.google.common.base.Strings;
import de.tblsoft.solr.pipeline.bean.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Document {
    private List<Field> fields = new ArrayList<Field>();
    private Long size;

    public List<Field> getFields() {
        return this.fields;
    }

    public Document() {
    }

    public Document(Document copy) {
        for (Field field : copy.getFields()) {
            this.fields.add(new Field(field));
        }
        this.fieldChanged();
    }

    public String getFieldValue(String name, String defaultValue) {
        String value = this.getFieldValue(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getFieldValue(String name) {
        List<String> fields = this.getFieldValues(name, new ArrayList<String>());
        if (fields.size() > 0) {
            return fields.get(0);
        }
        return null;
    }

    public List<String> getFieldValues(String name) {
        for (Field field : this.fields) {
            if (!name.equals(field.getName())) continue;
            return field.getValues();
        }
        return null;
    }

    public List<String> getFieldValues(String name, List<String> defaultValue) {
        List<String> fields = this.getFieldValues(name);
        if (fields != null) {
            return fields;
        }
        return defaultValue;
    }

    public void deleteField(String name) {
        ArrayList<Field> newFields = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (name.equals(field.getName())) continue;
            newFields.add(field);
        }
        this.fields = newFields;
        this.fieldChanged();
    }

    public void setField(String name, Collection<String> value) {
        this.setField(name, (List<String>)new ArrayList<String>(value));
    }

    public void setField(String name, List<String> value) {
        Field field = new Field(name, value);
        this.deleteField(name);
        this.fields.add(field);
        this.fieldChanged();
    }

    public void setField(Field field) {
        this.deleteField(field.getName());
        this.fields.add(field);
        this.fieldChanged();
    }

    public void setRawField(String name, Object value, String dataType) {
        Field field = new Field();
        field.setDatatype(dataType);
        field.setName(name);
        field.setRawValue(value);
        this.fields.add(field);
        this.fieldChanged();
    }

    public void addSubField(String name, Document document) {
        Field field = this.getField(name);
        if (field == null) {
            field = new Field();
            this.fields.add(field);
        }
        field.setDatatype("subField");
        field.setName(name);
        List<Document> documents = field.getDocuments();
        if (documents == null) {
            documents = new ArrayList<Document>();
        }
        documents.add(document);
        field.setDocuments(documents);
        this.fieldChanged();
    }

    public void setSubField(String name, List<Document> documents) {
        Field field = new Field();
        field.setDatatype("subField");
        field.setName(name);
        field.setDocuments(documents);
        this.setField(field);
    }

    public List<Document> getSubField(String name) {
        Field subField = this.getField(name);
        if (subField == null) {
            return null;
        }
        return subField.getDocuments();
    }

    public void setField(String name, Object value) {
        if (value instanceof List) {
            this.deleteField(name);
            this.addField(name, value);
        } else {
            this.setField(name, String.valueOf(value));
        }
    }

    public void addField(String name, Object value) {
        if (value instanceof List) {
            List valueList = (List)value;
            for (Object v : valueList) {
                this.addField(name, String.valueOf(v));
            }
        } else {
            this.addField(name, String.valueOf(value));
        }
    }

    public void setField(String name, String value) {
        Field field = new Field(name, value);
        this.deleteField(name);
        this.fields.add(field);
        this.fieldChanged();
    }

    public Field getField(String name) {
        for (Field field : this.fields) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public void addField(Field field) {
        this.addField(field.getName(), field.getValues(), field.getDatatype());
    }

    public void addField(String name, String value) {
        this.addField(name, value, null);
    }

    public void addField(String name, String value, String dataType) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.addField(name, values, dataType);
    }

    public void addField(String name, List<String> values, String dataType) {
        Field existingField = this.getField(name);
        if (existingField == null) {
            Field field = new Field(name, values);
            field.setDatatype(dataType);
            this.fields.add(field);
        } else {
            existingField.getValues().addAll(values);
        }
        this.fieldChanged();
    }

    public void addField(String name, List<String> values) {
        this.addField(name, values, null);
    }

    public void addFieldIfNotNullOrEmpty(String name, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return;
        }
        this.addField(name, value);
    }

    public void uniqueFieldValues(String name) {
        List<String> values = this.getFieldValues(name);
        if (values == null) {
            return;
        }
        HashSet<String> uniqueValues = new HashSet<String>(values);
        this.setField(name, uniqueValues);
    }

    public String toString() {
        return "Document{fields=" + this.fields + '}';
    }

    private void fieldChanged() {
        this.size = null;
    }

    public long getSize() {
        if (this.size == null) {
            long totalSize = 0L;
            for (Field field : this.getFields()) {
                totalSize += field.getSize();
            }
            this.size = totalSize;
        }
        return this.size;
    }
}

