/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.bean;

import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Field {
    private String name;
    private List<String> values;
    private List<Document> documents;
    private Object rawValue;
    private String datatype;

    public Field() {
    }

    public Field(String name, String value) {
        this.name = name;
        this.values = new ArrayList<String>();
        this.values.add(value);
    }

    public Field(String name, List<String> values) {
        this.name = name;
        this.values = values;
    }

    public Field(Field copy) {
        ArrayList<Object> values = new ArrayList();
        if (copy.getValues() != null) {
            values = new ArrayList<String>(copy.getValues());
        }
        this.name = copy.getName();
        this.values = values;
        this.rawValue = copy.getRawValue();
        this.documents = copy.getDocuments();
        this.datatype = copy.getDatatype();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addSubDocument(Document document) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(document);
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public String getValue() {
        Iterator<String> iterator = this.getValues().iterator();
        if (iterator.hasNext()) {
            String value = iterator.next();
            return value;
        }
        return null;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String toString() {
        return "Field{name='" + this.name + '\'' + ", values=" + this.values + ", datatype='" + this.datatype + '\'' + '}';
    }

    public long getSize() {
        if (this.values == null) {
            return 0L;
        }
        long totalSize = this.getName().length();
        for (String value : this.getValues()) {
            if (value == null) continue;
            totalSize += (long)value.length();
        }
        return totalSize;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(Object rawValue) {
        this.rawValue = rawValue;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public boolean hasValues() {
        if (this.values != null && this.values.size() > 0) {
            return true;
        }
        if (this.rawValue != null) {
            return true;
        }
        return this.documents != null && this.documents.size() > 0;
    }
}

