/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatusFilter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(AbstractStatusFilter.class);
    protected int documentCounter = 0;
    protected long lapStart = 0L;
    protected int lapCount = 0;
    protected long start = 0L;
    protected String webHook;
    protected List<String> fieldsToPrint;

    @Override
    public void init() {
        LOG.info("start processing");
        this.lapStart = System.currentTimeMillis();
        this.start = System.currentTimeMillis();
        this.webHook = this.getProperty("webHook", null);
        this.fieldsToPrint = this.getPropertyAsList("fieldsToPrint", null);
        if (this.webHook != null) {
            HTTPHelper.webHook(this.webHook, "status", "progress.start", "documentCounter", String.valueOf(this.documentCounter), "expectedDocumentCount", String.valueOf(this.pipelineExecuter.getExpectedDocumentCount()), "processId", this.getPipelineExecuter().getProcessId());
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        ++this.documentCounter;
        ++this.lapCount;
        if (this.printCurrentStatus()) {
            long now = System.currentTimeMillis();
            long duration = now - this.start;
            long lapDuration = now - this.lapStart;
            this.printStatus(duration, lapDuration, document);
            this.lapStart = now;
            this.lapCount = 0;
        }
        super.document(document);
    }

    abstract boolean printCurrentStatus();

    @Override
    public void end() {
        this.printEnd();
        super.end();
    }

    protected String getFormattedDuration(long duration) {
        if (duration < 300000L) {
            long durationInSeconds = duration / 1000L;
            return durationInSeconds + " seconds";
        }
        if (duration < 10800000L) {
            long durationInMinute = duration / 1000L / 60L;
            return durationInMinute + " minutes";
        }
        long durationInMinute = duration / 1000L / 60L;
        long durationInHours = durationInMinute / 60L;
        return durationInHours + " hours " + durationInMinute + " minutes";
    }

    void printStatus(long duration, long lapDuration, Document document) {
        StringBuilder printFields = new StringBuilder();
        if (this.fieldsToPrint != null) {
            for (String fieldToPrint : this.fieldsToPrint) {
                String fieldValue = document.getFieldValue(fieldToPrint);
                if (fieldValue == null) continue;
                printFields.append(" ");
                printFields.append(fieldToPrint);
                printFields.append(":");
                printFields.append(fieldValue);
            }
        }
        LOG.info("processed all " + this.documentCounter + " in " + this.getFormattedDuration(duration) + ". - processed the last " + this.lapCount + " documents in " + this.getFormattedDuration(lapDuration) + "." + printFields);
        if (this.webHook != null) {
            HTTPHelper.webHook(this.webHook, "status", "progress", "documentCounter", String.valueOf(this.documentCounter), "expectedDocumentCount", String.valueOf(this.pipelineExecuter.getExpectedDocumentCount()), "processId", this.getPipelineExecuter().getProcessId());
        }
    }

    void printEnd() {
        long duration = System.currentTimeMillis() - this.start;
        LOG.info("End. processed all " + this.documentCounter + " in " + this.getFormattedDuration(duration) + ".");
        if (this.webHook != null) {
            HTTPHelper.webHook(this.webHook, "status", "progress.end", "documentCounter", String.valueOf(this.documentCounter), "expectedDocumentCount", String.valueOf(this.pipelineExecuter.getExpectedDocumentCount()), "processId", this.getPipelineExecuter().getProcessId());
        }
    }
}

