/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractSubFieldFilter
extends AbstractFilter {
    private String subField;

    @Override
    public void init() {
        this.subField = this.getProperty("subField", null);
        super.init();
    }

    public List<Document> traverse(int i, String[] fieldNames, Document document) {
        List<Document> documents = document.getSubField(fieldNames[i]);
        if (documents == null) {
            return Arrays.asList(document);
        }
        ArrayList<Document> processedDocumentList = new ArrayList<Document>();
        for (Document d : documents) {
            List<Document> processed;
            if (i >= fieldNames.length - 1) {
                processed = this.processDocument(d);
                processedDocumentList.addAll(processed);
                continue;
            }
            processed = this.traverse(i + 1, fieldNames, d);
            processedDocumentList.addAll(processed);
        }
        document.setSubField(fieldNames[i], processedDocumentList);
        return Arrays.asList(document);
    }

    @Override
    public void document(Document document) {
        List<Document> processeddDocument = null;
        if (this.subField != null) {
            String[] splitted = this.subField.split(Pattern.quote("."));
            processeddDocument = this.traverse(0, splitted, document);
        } else {
            processeddDocument = this.processDocument(document);
        }
        if (processeddDocument != null) {
            for (Document d : processeddDocument) {
                super.document(d);
            }
        }
    }

    public abstract List<Document> processDocument(Document var1);
}

