/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.util.concurrent.AtomicLongMap;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import java.util.HashMap;
import java.util.Map;

public class AggregationCountFilter
extends AbstractFilter {
    Map<String, AtomicLongMap<String>> aggregation = new HashMap<String, AtomicLongMap<String>>();
    String splitRegex;

    @Override
    public void init() {
        this.splitRegex = this.getProperty("splitRegex", null);
        super.init();
    }

    @Override
    public void document(Document document) {
        for (Field field : document.getFields()) {
            AtomicLongMap countMap = this.aggregation.get(field.getName());
            if (countMap == null) {
                countMap = AtomicLongMap.create();
            }
            for (String value : field.getValues()) {
                if (this.splitRegex != null) {
                    String[] values;
                    if (value == null) continue;
                    for (String val : values = value.split(this.splitRegex)) {
                        countMap.incrementAndGet((Object)val);
                    }
                    continue;
                }
                countMap.incrementAndGet((Object)value);
            }
            this.aggregation.put(field.getName(), (AtomicLongMap<String>)countMap);
        }
    }

    @Override
    public void end() {
        for (Map.Entry<String, AtomicLongMap<String>> entry : this.aggregation.entrySet()) {
            String fieldName = entry.getKey();
            AtomicLongMap<String> fieldValue = entry.getValue();
            for (Map.Entry fieldValueEntry : fieldValue.asMap().entrySet()) {
                String value = (String)fieldValueEntry.getKey();
                Long count = (Long)fieldValueEntry.getValue();
                Document document = new Document();
                document.setField("value", value);
                document.setField("count", count);
                document.setField("type", fieldName);
                super.document(document);
            }
        }
        super.end();
    }
}

