/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public abstract class BaseBlacklistFilter
extends AbstractFilter {
    Map<String, HashSet<String>> topicValues;
    String fieldTopic;
    String fieldValue;

    @Override
    public void init() {
        this.topicValues = new HashMap<String, HashSet<String>>();
        InputStream in = null;
        try {
            String filename = this.getProperty("filename", null);
            String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
            in = IOUtils.getInputStream(absoluteFilename);
            InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8.name());
            CSVFormat format = CSVFormat.RFC4180.withHeader(new String[0]).withDelimiter(',');
            CSVParser parser = format.parse((Reader)reader);
            for (CSVRecord record : parser) {
                String topic = record.get(0);
                String value = record.get(1);
                if (!this.topicValues.containsKey(topic)) {
                    this.topicValues.put(topic, new HashSet());
                }
                this.topicValues.get(topic).add(value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.fieldTopic = this.getProperty("fieldTopic", null);
        this.fieldValue = this.getProperty("fieldValue", null);
        super.init();
    }
}

