/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import bsh.EvalError;
import bsh.Interpreter;
import com.google.common.base.Strings;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BeanShellFilter
extends AbstractFilter {
    private Interpreter interpreter;
    private String filename;
    private Map<String, Object> init = new HashMap<String, Object>();

    @Override
    public void init() {
        String internalFilename = this.getProperty("filename", null);
        this.verify(internalFilename, "For the BeanShellFilter a filename property must be defined.");
        this.filename = IOUtils.getAbsoluteFile(this.getBaseDir(), internalFilename);
        String initFilename = this.getProperty("initFilename", null);
        this.interpreter = new Interpreter();
        try {
            this.interpreter.set("instance", (Object)this);
            this.interpreter.set("init", this.init);
            if (!Strings.isNullOrEmpty((String)initFilename)) {
                String absoluteInitFileName = IOUtils.getAbsoluteFile(this.getBaseDir(), initFilename);
                this.interpreter.source(absoluteInitFileName);
                this.init = (Map)this.interpreter.get("init");
            }
        }
        catch (EvalError evalError) {
            throw new RuntimeException(evalError);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    public void superDocument(Document document) {
        super.document(document);
    }

    @Override
    public void document(Document document) {
        try {
            this.interpreter.set("document", (Object)document);
            this.interpreter.source(this.filename);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (EvalError evalError) {
            throw new RuntimeException(evalError);
        }
    }
}

