/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Joiner;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CSVWriter
extends AbstractFilter {
    private CSVPrinter printer;
    private String multiValueSeperator;
    private boolean firstDocument = true;
    private String delimiter;
    private String[] headers;
    private String absoluteFilename;
    private boolean withHeaders = true;
    private boolean append = true;

    @Override
    public void init() {
        try {
            String filename = this.getProperty("filename", null);
            this.absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
            this.delimiter = this.getProperty("delimiter", ",");
            this.headers = this.getPropertyAsArray("headers", null);
            this.multiValueSeperator = this.getProperty("multiValueSeperator", ";");
            this.withHeaders = this.getPropertyAsBoolean("withHeaders", true);
            this.append = this.getPropertyAsBoolean("append", false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    String[] getFieldNames(Document document) {
        ArrayList<String> headersFromDocument = new ArrayList<String>();
        for (Field field : document.getFields()) {
            headersFromDocument.add(field.getName());
        }
        return headersFromDocument.toArray(new String[headersFromDocument.size()]);
    }

    @Override
    public void document(Document document) {
        if (this.firstDocument) {
            try {
                OpenOption[] openOptionArray;
                if (this.headers == null) {
                    this.headers = this.getFieldNames(document);
                }
                CSVFormat format = CSVFormat.RFC4180;
                format = this.withHeaders ? format.withDelimiter(this.delimiter.charAt(0)).withHeader(this.headers) : format.withDelimiter(this.delimiter.charAt(0));
                if (!this.append) {
                    File file = new File(this.absoluteFilename);
                    file.delete();
                }
                if (this.append) {
                    OpenOption[] openOptionArray2 = new OpenOption[2];
                    openOptionArray2[0] = StandardOpenOption.APPEND;
                    openOptionArray = openOptionArray2;
                    openOptionArray2[1] = StandardOpenOption.CREATE;
                } else {
                    OpenOption[] openOptionArray3 = new OpenOption[1];
                    openOptionArray = openOptionArray3;
                    openOptionArray3[0] = StandardOpenOption.CREATE;
                }
                OpenOption[] openOptions = openOptionArray;
                BufferedWriter writer = Files.newBufferedWriter(Paths.get(this.absoluteFilename, new String[0]), openOptions);
                this.printer = new CSVPrinter((Appendable)writer, format);
                this.firstDocument = false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            ArrayList csvRows = new ArrayList();
            ArrayList<String> csvList = new ArrayList<String>();
            for (String headerField : this.headers) {
                Field field = document.getField(headerField);
                String value = null;
                if (field != null && field.getValues() != null) {
                    value = Joiner.on((String)this.multiValueSeperator).skipNulls().join(field.getValues());
                }
                csvList.add(value);
            }
            csvRows.add(csvList);
            this.printer.printRecords(csvRows);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.document(document);
    }

    @Override
    public void end() {
        try {
            if (this.printer != null) {
                this.printer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.end();
    }
}

