/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;

public class CharCounterFilter
extends AbstractFilter {
    private String fieldName;
    private String charCountFieldName;

    @Override
    public void init() {
        this.fieldName = this.getProperty("fieldName", null);
        this.verify(this.fieldName, "For the TokenCounterFilter a fieldName property must be defined.");
        this.charCountFieldName = this.getProperty("charCountFieldName", "charCount");
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> values = document.getFieldValues(this.fieldName, new ArrayList<String>());
        int charCount = 0;
        for (String value : values) {
            charCount += value.length();
        }
        document.setField(this.charCountFieldName, String.valueOf(charCount));
        super.document(document);
    }
}

