/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class CheckDuplicateFilter
extends AbstractFilter {
    private Set<String> duplicates;
    private File absoluteDuplicatesStoreFile;
    private String duplicateFieldName;
    private int counter = 0;
    private int checkpoint = 1000;

    @Override
    public void init() {
        String duplicatesStoreFile = this.getProperty("duplicatesStoreFile", "duplicatesStore.txt");
        this.duplicateFieldName = this.getProperty("duplicateFieldName", null);
        this.checkpoint = this.getPropertyAsInt("checkpoint", 1000);
        this.absoluteDuplicatesStoreFile = IOUtils.getAbsoluteFileAsFile(this.getBaseDir(), duplicatesStoreFile);
        if (!this.absoluteDuplicatesStoreFile.exists()) {
            this.duplicates = new HashSet<String>();
        } else {
            try {
                for (String line : FileUtils.readLines((File)this.absoluteDuplicatesStoreFile)) {
                    this.duplicates.add(line);
                }
            }
            catch (IOException e) {
                this.duplicates = new HashSet<String>();
            }
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        String duplicateFieldValue;
        ++this.counter;
        if (this.counter % this.checkpoint == 0) {
            this.saveDuplicatesToFile();
        }
        if ((duplicateFieldValue = document.getFieldValue(this.duplicateFieldName)) == null) {
            super.document(document);
        }
        if (!this.duplicates.contains(duplicateFieldValue)) {
            this.duplicates.add(duplicateFieldValue);
        }
    }

    @Override
    public void end() {
        this.saveDuplicatesToFile();
        super.end();
    }

    void saveDuplicatesToFile() {
        try {
            FileUtils.writeLines((File)this.absoluteDuplicatesStoreFile, this.duplicates);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

