/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ConradJsoupFilter
extends AbstractFilter {
    protected Document jsoupDocument;
    protected String htmlField;
    protected String html;

    @Override
    public void init() {
        this.htmlField = this.getProperty("htmlField", "html");
        super.init();
    }

    @Override
    public void document(de.tblsoft.solr.pipeline.bean.Document document) {
        this.html = document.getFieldValue(this.htmlField);
        this.jsoupDocument = Jsoup.parse((String)this.html);
        Elements technicaldetails = this.jsoupDocument.select("section[id=technicaldetail] > div > dl");
        for (int i = 0; i < technicaldetails.size(); ++i) {
            Element detail = (Element)technicaldetails.get(i);
            String name = detail.select("dt > div > a").text();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = detail.select("dt").text();
            }
            String value = detail.select("dd").text();
            String key = this.normalizeKey(name);
            document.setField("attributekey_" + key, value);
            document.setField("attributename_" + key, name);
        }
        Elements breadcrumb = this.jsoupDocument.select("ul[class=ccpBreadcrumb] > li");
        for (int i = 1; i < breadcrumb.size(); ++i) {
            Element categoryElement = (Element)breadcrumb.get(i);
            String category = categoryElement.text();
            document.addField("category", category);
        }
        Elements brandHtml = this.jsoupDocument.select("[itemprop=brand]");
        String brand = brandHtml.text();
        if (StringUtils.isEmpty((CharSequence)brand)) {
            brand = brandHtml.select("img").attr("alt");
        }
        document.setField("brand", brand);
        super.document(document);
    }

    String normalizeKey(String key) {
        key = key.replaceAll(" ", "_");
        key = key.replaceAll("[^a-zA-Z0-9_-]+", "");
        return key;
    }
}

