/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateFilter
extends AbstractFilter {
    private SimpleDateFormat inputDateFormat;
    private SimpleDateFormat outputDateFormat;
    private String dateField;

    @Override
    public void init() {
        String inputDateFormatString = this.getProperty("inputDateFormat", null);
        this.verify(inputDateFormatString, "For the DateFilter a inputDateFormat must be defined.");
        this.inputDateFormat = new SimpleDateFormat(inputDateFormatString, Locale.ENGLISH);
        String outputDateFormatString = this.getProperty("outputDateFormat", null);
        this.verify(outputDateFormatString, "For the DateFilter a outputDateFormat must be defined.");
        this.outputDateFormat = new SimpleDateFormat(outputDateFormatString, Locale.ENGLISH);
        this.dateField = this.getProperty("dateField", null);
        this.verify(this.dateField, "For the DateFilter a dateField must be defined.");
        super.init();
    }

    @Override
    public void document(Document document) {
        String value = document.getFieldValue(this.dateField);
        if (!Strings.isNullOrEmpty((String)value)) {
            try {
                Date inputDate = this.inputDateFormat.parse(value);
                String newValue = this.outputDateFormat.format(inputDate);
                document.setField(this.dateField, newValue);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        super.document(document);
    }
}

