/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.pipeline.bean.Pipeline;
import de.tblsoft.solr.pipeline.filter.LookupFilter;
import java.util.Map;

public class DocumentJoinerFilter
extends AbstractFilter {
    private Map<String, Document> lookupMap;
    private String key;

    @Override
    public void init() {
        String pipelineId = this.getProperty("pipelineId", null);
        this.key = this.getProperty("key", "id");
        Pipeline pipeline = this.pipelineExecuter.getPipeline(pipelineId);
        PipelineExecuter pipelineExecuter = new PipelineExecuter(pipeline, this.getBaseDir());
        pipelineExecuter.execute();
        LookupFilter lookupFilter = (LookupFilter)pipelineExecuter.getFilterById("lookup");
        if (lookupFilter == null) {
            throw new RuntimeException("There is no lookup filter defined.");
        }
        this.lookupMap = lookupFilter.getLookup();
        super.init();
    }

    @Override
    public void document(Document document) {
        Document joinDocument = this.lookupMap.get(document.getFieldValue(this.key));
        if (joinDocument != null) {
            for (Field fieldToJoin : joinDocument.getFields()) {
                if (fieldToJoin.getName().equals(this.key)) continue;
                document.addField(fieldToJoin);
            }
        }
        super.document(document);
    }
}

