/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.HashMap;
import java.util.Map;

public class DuplicateRemovalFilter
extends AbstractFilter {
    private String fieldName;
    private boolean passThroughNullValues;
    private Map<String, Document> duplicateRemovalMap = new HashMap<String, Document>();

    @Override
    public void init() {
        this.fieldName = this.getProperty("fieldName", null);
        this.passThroughNullValues = this.getPropertyAsBoolean("passThroughNullValues", true);
        this.verify(this.fieldName, "For the DuplicateRemovalFilter a fieldName property must be defined.");
        super.init();
    }

    @Override
    public void document(Document document) {
        String key = document.getFieldValue(this.fieldName);
        if (key != null) {
            this.duplicateRemovalMap.put(key, document);
        } else if (this.passThroughNullValues) {
            super.document(document);
        }
    }

    @Override
    public void end() {
        for (Document document : this.duplicateRemovalMap.values()) {
            super.document(document);
        }
        super.end();
    }
}

