/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.tblsoft.solr.elastic.AliasManager;
import de.tblsoft.solr.http.ElasticHelper;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.ElasticBulkResponse;
import de.tblsoft.solr.pipeline.bean.ElasticResponse;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticWriter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(ElasticWriter.class);
    private Gson gson;
    private String jsonDatePattern;
    private String type;
    private String location;
    private String elasticMappingLocation;
    private boolean delete;
    private String idField;
    private Boolean hashId = false;
    private List<Document> buffer = new ArrayList<Document>();
    private int bufferSize = 10000;
    private long currentBufferContentSize = 0L;
    private long maxBufferContentSize = 3000000L;
    private boolean detectNumberValues = true;
    private boolean failOnError = true;
    private String indexUrl;
    private Integer housekeepingCount;
    private String housekeppingStrategy;
    private Boolean housekeepingEnabled = false;
    private String alias;
    private String bulkMethodFieldName;
    private boolean includeTypeName;

    @Override
    public void init() {
        this.bulkMethodFieldName = this.getProperty("bulkMethodFieldName", null);
        this.alias = this.getProperty("alias", null);
        this.housekeepingEnabled = this.getPropertyAsBoolean("housekeepingEnabled", this.housekeepingEnabled);
        this.housekeepingCount = this.getPropertyAsInt("housekeepingCount", 5);
        this.housekeppingStrategy = this.getProperty("housekeppingStrategy", "linear");
        this.bufferSize = this.getPropertyAsInt("bufferSize", 10000);
        this.location = this.getProperty("location", null);
        this.verify(this.location, "For the JsonWriter a location must be defined.");
        this.failOnError = this.getPropertyAsBoolean("failOnError", Boolean.TRUE);
        this.delete = this.getPropertyAsBoolean("delete", Boolean.TRUE);
        this.detectNumberValues = this.getPropertyAsBoolean("detectNumberValues", Boolean.TRUE);
        this.elasticMappingLocation = this.getProperty("elasticMappingLocation", null);
        this.idField = this.getProperty("idField", null);
        this.hashId = this.getPropertyAsBoolean("hashId", false);
        this.includeTypeName = this.getPropertyAsBoolean("includeTypeName", false);
        this.jsonDatePattern = this.getProperty("jsonDatePattern", "yyyy-MM-dd'T'HH:mm:ssZ");
        GsonBuilder builder = new GsonBuilder().setDateFormat(this.jsonDatePattern);
        this.gson = builder.create();
        try {
            this.indexUrl = this.housekeepingEnabled.booleanValue() ? AliasManager.getElasticUrlWithDatePattern(this.location) : ElasticHelper.getIndexUrl(this.location);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (this.delete && !"elasticupdate".equals(this.type)) {
            String response = HTTPHelper.delete(this.indexUrl);
            ElasticResponse elasticResponse = (ElasticResponse)this.gson.fromJson(response, ElasticResponse.class);
            if (!Boolean.TRUE.equals(elasticResponse.getAcknowledged())) {
                LOG.error("Could not delete index: {} error: {} ", (Object)this.indexUrl, (Object)response);
            }
            LOG.debug("delete elastic index for url {} and response {}", (Object)this.indexUrl, (Object)response);
        }
        if (this.elasticMappingLocation != null) {
            try {
                String aliasFromUrl;
                String absoluteElasticMappingLocation = IOUtils.getAbsoluteFile(this.getBaseDir(), this.elasticMappingLocation);
                String mappingJson = IOUtils.getString(absoluteElasticMappingLocation);
                String mappingUrl = ElasticHelper.getIndexUrl(this.indexUrl);
                int statusCode = HTTPHelper.getStatusCode(mappingUrl);
                LOG.debug("status code {}", (Object)statusCode);
                if (this.includeTypeName) {
                    mappingUrl = mappingUrl + "?include_type_name=true";
                }
                LOG.debug("mapping url: {} mappingJson: {}", (Object)mappingUrl, (Object)mappingJson);
                if (statusCode == 404) {
                    String response = HTTPHelper.put(mappingUrl, mappingJson, "application/json");
                    ElasticResponse elasticResponse = (ElasticResponse)this.gson.fromJson(response, ElasticResponse.class);
                    if (!Boolean.TRUE.equals(elasticResponse.getAcknowledged())) {
                        LOG.error("Could not create mapping for url: {} mappingJson: {} error: {} ", new Object[]{mappingUrl, mappingJson, response});
                        throw new RuntimeException("Could not create mapping");
                    }
                    LOG.debug("mapping response {}", (Object)response);
                }
                if (this.housekeepingEnabled.booleanValue() && !AliasManager.exists(this.indexUrl, aliasFromUrl = ElasticHelper.getIndexFromUrl(this.location))) {
                    String index = ElasticHelper.getIndexFromUrl(this.indexUrl);
                    LOG.info("Create the alias: {} for index: {}", (Object)aliasFromUrl, (Object)index);
                    AliasManager.switchAlias(this.indexUrl, aliasFromUrl, new ArrayList<String>(), index);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.init();
    }

    Object transformRawValue(Field field) {
        String dataType = field.getDatatype();
        if (dataType.equals("json")) {
            return this.gson.toJsonTree(field.getRawValue());
        }
        return null;
    }

    static Object transformDatatype(Field field, boolean detectNumberValues) {
        String value = field.getValue();
        String dataType = field.getDatatype();
        if (dataType == null) {
            dataType = "string";
        }
        if (dataType.equals("list.string")) {
            return field.getValues();
        }
        if (dataType.equals("json")) {
            Gson gson = new Gson();
            return gson.toJson(field.getRawValue());
        }
        if (!detectNumberValues) {
            return value;
        }
        if (field.getDatatype() != null && "string".equals(field.getDatatype())) {
            return value;
        }
        if (!detectNumberValues) {
            return value;
        }
        if (NumberUtils.isNumber((String)value)) {
            try {
                Long intValue = Long.valueOf(value);
                return intValue;
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    void procesBuffer() {
        if (this.buffer.size() == 0) {
            return;
        }
        StringBuilder bulkRequest = new StringBuilder();
        try {
            for (Document document : this.buffer) {
                String bulkMethod;
                Map<String, Object> jsonDocument = this.mapToJson(document, this.detectNumberValues);
                if (jsonDocument.isEmpty()) continue;
                String id = Strings.isNullOrEmpty((String)this.idField) ? UUID.randomUUID().toString() : (this.hashId != false ? DigestUtils.md5Hex((String)document.getFieldValue(this.idField)) : document.getFieldValue(this.idField));
                String index = ElasticHelper.getIndexFromUrl(this.indexUrl);
                String type = ElasticHelper.getTypeFromUrl(this.location);
                if (this.isDeleteBulkMethod(document)) {
                    bulkMethod = this.createBulkMethod("delete", index, type, id);
                    bulkRequest.append(bulkMethod).append(" \n");
                    continue;
                }
                bulkMethod = this.createBulkMethod("index", index, type, id);
                String json = this.gson.toJson(jsonDocument);
                bulkRequest.append(bulkMethod).append(" \n");
                bulkRequest.append(json).append(" \n");
            }
            String bulkUrl = ElasticHelper.getBulkUrl(this.indexUrl);
            LOG.debug("bulk url: {} bulkRequest: {}", (Object)bulkUrl, (Object)bulkRequest);
            String response = HTTPHelper.post(bulkUrl, bulkRequest.toString(), "application/json");
            ElasticBulkResponse elasticBulkResponse = (ElasticBulkResponse)this.gson.fromJson(response, ElasticBulkResponse.class);
            if (Boolean.TRUE.equals(elasticBulkResponse.getErrors())) {
                LOG.error("There was an error processing the bulk request {} with message: {}", (Object)bulkRequest.toString(), (Object)response);
                throw new Exception("There was an error processing the bulk request");
            }
        }
        catch (Exception e) {
            LOG.info("There was an error processing the bulk request: " + e.getMessage());
            LOG.info(bulkRequest.toString());
            if (this.failOnError) {
                throw new RuntimeException(e);
            }
            LOG.info("Continue processing ... ");
        }
    }

    private boolean isDeleteBulkMethod(Document document) {
        if (Strings.isNullOrEmpty((String)this.bulkMethodFieldName)) {
            return false;
        }
        String bulkMethod = document.getFieldValue(this.bulkMethodFieldName);
        return "delete".equals(bulkMethod);
    }

    @Override
    public void document(Document document) {
        long documentSize = document.getSize();
        if (this.buffer.size() >= this.bufferSize || this.currentBufferContentSize + documentSize > this.maxBufferContentSize) {
            this.procesBuffer();
            LOG.debug("bufferContentSize: " + this.currentBufferContentSize + " bufferSize: " + this.buffer.size());
            this.buffer = new ArrayList<Document>();
            this.currentBufferContentSize = 0L;
        }
        this.buffer.add(document);
        this.currentBufferContentSize += documentSize;
        super.document(document);
    }

    public String mapToJsonString(List<Document> documentList, boolean detectNumberValues) {
        ArrayList<Map<String, Object>> documentMap = new ArrayList<Map<String, Object>>();
        for (Document document : documentList) {
            documentMap.add(this.mapToJson(document, detectNumberValues));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(documentMap);
        return json;
    }

    static Map createExpandedValue(String flatName, Object value) {
        HashMap<String, Object> last;
        HashMap<String, Object> result = last = new HashMap<String, Object>();
        String[] parts = flatName.split("\\.");
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            if (i == parts.length - 1) {
                last.put(part, value);
                continue;
            }
            HashMap lastMap = new HashMap();
            last.put(part, lastMap);
            last = lastMap;
        }
        return result;
    }

    private Map<String, Object> mapToJson(Document document, boolean detectNumberValues) {
        HashMap<String, Object> jsonDocument = new HashMap<String, Object>();
        for (Field field : document.getFields()) {
            if (!field.hasValues()) continue;
            boolean fieldIsFlat = field.getName().contains(".");
            String fieldName = field.getName();
            Object fieldValue = field.getValues();
            Object fieldRawValue = field.getRawValue();
            List<Document> subDocuments = field.getDocuments();
            if (subDocuments != null) {
                ArrayList<Map<String, Object>> subFieldValue = new ArrayList<Map<String, Object>>();
                for (Document subDocument : subDocuments) {
                    subFieldValue.add(this.mapToJson(subDocument, detectNumberValues));
                }
                fieldValue = subFieldValue;
            } else if (fieldRawValue != null) {
                fieldValue = this.transformRawValue(field);
            } else if (field.getValues().size() == 1) {
                fieldValue = ElasticWriter.transformDatatype(field, detectNumberValues);
            } else if (fieldIsFlat) {
                fieldValue = ElasticWriter.createExpandedValue(fieldName, fieldValue);
                fieldName = StringUtils.substringBefore((String)fieldName, (String)".");
            }
            jsonDocument.put(fieldName, fieldValue);
        }
        return jsonDocument;
    }

    public static Object getFielddddValueByDataType(Field field) {
        if (field.getDatatype() == null) {
            return null;
        }
        if ("multipoint".equals(field.getDatatype())) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("type", "multipoint");
            ArrayList<List<Double>> coordinates = new ArrayList<List<Double>>();
            for (String value : field.getValues()) {
                String[] splitted = value.split(",");
                if (splitted.length != 2) continue;
                coordinates.add(Arrays.asList(Double.valueOf(splitted[1]), Double.valueOf(splitted[0])));
            }
            data.put("coordinates", coordinates);
            return data;
        }
        return null;
    }

    public String createBulkMethod(String method, String index, String type, String id) {
        String bulkMethod = "{ \"" + method + "\" : { \"_index\" : \"" + index + "\", \"_type\" : \"" + type + "\", \"_id\" : \"" + id + "\"} }";
        return bulkMethod;
    }

    public void housekeeping() {
        String prefix = AliasManager.getIndexPrefixByUrl(this.indexUrl);
        if (Strings.isNullOrEmpty((String)prefix)) {
            throw new RuntimeException("Could not extract prefix from url: " + this.indexUrl);
        }
        List<String> indexes = AliasManager.getIndexesByPrefix(this.indexUrl, prefix);
        Collections.sort(indexes);
        try {
            String alias = ElasticHelper.getIndexFromUrl(this.location);
            AliasManager.switchAlias(this.location, alias, indexes, indexes.get(indexes.size() - 1));
        }
        catch (Exception e) {
            LOG.error("There was an error switching the alias: " + e.getMessage(), (Throwable)e);
        }
        int indexesToDeleteCount = indexes.size() - this.housekeepingCount;
        if (indexesToDeleteCount < 0) {
            indexesToDeleteCount = 0;
        }
        List<String> indexToDeleteList = indexes.subList(0, indexesToDeleteCount);
        for (String indexToDelete : indexToDeleteList) {
            try {
                String deleteUrl = ElasticHelper.getIndexUrl(this.location, indexToDelete);
                HTTPHelper.delete(deleteUrl);
            }
            catch (Exception e) {
                LOG.error("There was an error deleting the index: " + indexToDelete, (Throwable)e);
            }
        }
    }

    @Override
    public void end() {
        this.procesBuffer();
        if (this.housekeepingEnabled.booleanValue()) {
            this.housekeeping();
        }
        if (this.alias != null) {
            try {
                String index = ElasticHelper.getIndexFromUrl(this.indexUrl);
                AliasManager.switchAlias(this.indexUrl, this.alias, new ArrayList<String>(), index);
            }
            catch (Exception e) {
                LOG.info("Error switching alias, because: " + e.getMessage());
            }
        }
        super.end();
    }
}

