/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.beust.jcommander.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ElasticdumpFileWriter
extends AbstractFilter {
    BufferedWriter bw = null;
    FileWriter fw = null;
    private Gson gson;
    private String index;
    private String type;
    private String filepath;
    private String format;
    private boolean delete;
    private String idField;

    @Override
    public void init() {
        this.filepath = this.getProperty("filepath", null);
        this.verify(this.filepath, "For the JsonWriter a filepath must be defined.");
        this.delete = this.getPropertyAsBoolean("delete", Boolean.TRUE);
        this.index = this.getProperty("index", null);
        this.type = this.getProperty("type", null);
        this.format = this.getProperty("format", "elasticdump");
        this.idField = this.getProperty("idField", null);
        this.gson = new GsonBuilder().create();
        String absoluteFilepath = IOUtils.getAbsoluteFile(this.getBaseDir(), this.filepath);
        File file = new File(absoluteFilepath);
        try {
            if (file.exists() && this.delete) {
                file.delete();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            this.fw = new FileWriter(file.getAbsoluteFile(), true);
            this.bw = new BufferedWriter(this.fw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    static Object transformDatatype(String value) {
        if (NumberUtils.isNumber((String)value)) {
            try {
                Long intValue = Long.valueOf(value);
                return intValue;
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    @Override
    public void document(Document document) {
        Map<String, Object> jsonDocument = ElasticdumpFileWriter.mapToJson(document);
        if (!jsonDocument.isEmpty()) {
            String id = Strings.isStringEmpty((String)this.idField) ? UUID.randomUUID().toString() : document.getFieldValue(this.idField);
            String serializedDoc = null;
            serializedDoc = "bulk".equals(this.format) ? this.serializeElasticBulk(id, jsonDocument) : this.serializeElasticdump(id, jsonDocument);
            try {
                this.bw.write(serializedDoc);
                this.bw.newLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while writing data to file!", e);
            }
        }
        super.document(document);
    }

    public String serializeElasticBulk(String id, Map<String, Object> doc) {
        String bulkMethod = "{ \"index\" : { \"_index\" : \"" + this.index + "\", \"_type\" : \"" + this.type + "\", \"_id\" : \"" + id + "\" } }";
        String json = this.gson.toJson(doc);
        StringBuilder bulkLine = new StringBuilder();
        bulkLine.append(bulkMethod).append(" \n");
        bulkLine.append(json);
        return bulkLine.toString();
    }

    public String serializeElasticdump(String id, Map<String, Object> doc) {
        String source = this.gson.toJson(doc);
        String serializedDoc = "{\"_index\":\"" + this.index + "\",\"_type\":\"" + this.type + "\",\"_source\":" + source + "}";
        return serializedDoc;
    }

    static Map createExpandedValue(String flatName, Object value) {
        HashMap<String, Object> last;
        HashMap<String, Object> result = last = new HashMap<String, Object>();
        String[] parts = flatName.split("\\.");
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            if (i == parts.length - 1) {
                last.put(part, value);
                continue;
            }
            HashMap lastMap = new HashMap();
            last.put(part, lastMap);
            last = lastMap;
        }
        return result;
    }

    static Map<String, Object> mapToJson(Document document) {
        HashMap<String, Object> jsonDocument = new HashMap<String, Object>();
        for (Field field : document.getFields()) {
            List<String> values = field.getValues();
            if (values == null || values.isEmpty()) continue;
            boolean fieldIsFlat = field.getName().contains(".");
            String fieldName = field.getName();
            Object fieldValue = field.getValues();
            if (values.size() == 1) {
                fieldValue = ElasticdumpFileWriter.transformDatatype(field.getValue());
            }
            if (fieldIsFlat) {
                fieldValue = ElasticdumpFileWriter.createExpandedValue(fieldName, fieldValue);
                if (jsonDocument.containsKey(fieldName = StringUtils.substringBefore((String)fieldName, (String)"."))) {
                    Map existingValue = (Map)jsonDocument.get(fieldName);
                    Map newValue = ElasticdumpFileWriter.deepMerge(existingValue, (Map)fieldValue);
                    jsonDocument.put(fieldName, newValue);
                    continue;
                }
                jsonDocument.put(fieldName, fieldValue);
                continue;
            }
            jsonDocument.put(fieldName, fieldValue);
        }
        return jsonDocument;
    }

    public String createBulkMethod(String method, String index, String type, String id) {
        String bulkMethod = "{ \"" + method + "\" : { \"_index\" : \"" + index + "\", \"_type\" : \"" + type + "\", \"_id\" : \"" + id + "\" } }";
        return bulkMethod;
    }

    @Override
    public void end() {
        try {
            if (this.bw != null) {
                this.bw.close();
            }
            if (this.fw != null) {
                this.fw.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.end();
    }

    private static Map deepMerge(Map original, Map newMap) {
        for (Object key : newMap.keySet()) {
            Object newChild;
            Object originalChild;
            if (newMap.get(key) instanceof Map && original.get(key) instanceof Map) {
                originalChild = (Map)original.get(key);
                newChild = (Map)newMap.get(key);
                original.put(key, ElasticdumpFileWriter.deepMerge((Map)originalChild, (Map)newChild));
                continue;
            }
            if (newMap.get(key) instanceof List && original.get(key) instanceof List) {
                originalChild = (List)original.get(key);
                newChild = (List)newMap.get(key);
                Iterator iterator = newChild.iterator();
                while (iterator.hasNext()) {
                    Object each = iterator.next();
                    if (originalChild.contains(each)) continue;
                    originalChild.add(each);
                }
                continue;
            }
            original.put(key, newMap.get(key));
        }
        return original;
    }
}

