/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class FieldSplitter
extends AbstractFilter {
    private String sourceField;
    private String destField;
    private String splitChar;
    private boolean trimValues;

    @Override
    public void init() {
        this.sourceField = this.getProperty("sourceField", null);
        this.verify(this.sourceField, "For the FieldSplitter a sourceField property must be defined.");
        this.destField = this.getProperty("destField", null);
        this.splitChar = this.getProperty("splitChar", ",");
        this.trimValues = this.getPropertyAsBoolean("trimValues", false);
        if (Strings.isNullOrEmpty((String)this.destField)) {
            this.destField = this.sourceField;
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        this.processValues(document);
        super.document(document);
    }

    void processValues(Document document) {
        List<String> values = document.getFieldValues(this.sourceField);
        if (values == null) {
            return;
        }
        ArrayList<String> splittedList = new ArrayList<String>();
        for (String value : values) {
            String[] splittedValues;
            for (String splittedValue : splittedValues = value.split(Pattern.quote(this.splitChar))) {
                if (this.trimValues) {
                    splittedValue = splittedValue.trim();
                }
                splittedList.add(splittedValue);
            }
        }
        document.setField(this.destField, (List<String>)splittedList);
    }
}

