/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class FileMathFilter
extends AbstractFilter {
    String filepath;
    AggregationId idField;
    String field1;
    String field2;
    boolean field1FromFile;
    String operator;
    String fieldResult;
    Map<String, Document> fileData;

    @Override
    public void init() {
        this.filepath = this.getProperty("filepath", null);
        this.verify(this.filepath, "A filepath must be defined!");
        String absolutePath = IOUtils.getAbsoluteFile(this.getBaseDir(), this.filepath);
        String aggId = this.getProperty("idField", null);
        this.verify(aggId, "A idField must be defined!");
        String[] fields = aggId.split(",");
        this.idField = new AggregationId(Arrays.asList(fields));
        this.fileData = new HashMap<String, Document>();
        List<Map<String, String>> csvData = FileMathFilter.loadCsvAsMap(absolutePath);
        for (Map<String, String> entry : csvData) {
            Document doc = new Document();
            for (Map.Entry<String, String> entrySet : entry.entrySet()) {
                doc.setField(entrySet.getKey(), entrySet.getValue());
            }
            String docId = this.idField.buildId(doc);
            this.fileData.put(docId, doc);
        }
        this.field1 = this.getProperty("field1", null);
        this.verify(this.field1, "A field1 must be defined!");
        this.field2 = this.getProperty("field2", null);
        this.verify(this.field2, "A field2 must be defined!");
        this.fieldResult = this.getProperty("fieldResult", null);
        this.verify(this.fieldResult, "A fieldResult must be defined!");
        this.field1FromFile = this.getPropertyAsBoolean("field1FromFile", true);
        this.operator = this.getProperty("operator", "*");
        super.init();
    }

    public static List<Map<String, String>> loadCsvAsMap(String absolutePath) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        InputStream in = null;
        try {
            in = IOUtils.getInputStream(absolutePath);
            InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8.name());
            CSVFormat format = CSVFormat.RFC4180.withHeader(new String[0]).withDelimiter(',');
            CSVParser parser = format.parse((Reader)reader);
            for (CSVRecord record : parser) {
                result.add(record.toMap());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    @Override
    public void document(Document document) {
        String docId = this.idField.buildId(document);
        if (docId != null && this.fileData.containsKey(docId)) {
            Document docFile = this.fileData.get(docId);
            Float result = this.calculate(docFile, document);
            document.setField(this.fieldResult, result.toString());
        }
        super.document(document);
    }

    public Float calculate(Document docFile, Document doc) {
        Float val2;
        Float val1;
        Float result = null;
        if (this.field1FromFile) {
            val1 = Float.valueOf(Float.parseFloat(docFile.getFieldValue(this.field1)));
            val2 = Float.valueOf(Float.parseFloat(doc.getFieldValue(this.field2)));
        } else {
            val1 = Float.valueOf(Float.parseFloat(doc.getFieldValue(this.field1)));
            val2 = Float.valueOf(Float.parseFloat(docFile.getFieldValue(this.field2)));
        }
        if ("+".equals(this.operator)) {
            result = Float.valueOf(val1.floatValue() + val2.floatValue());
        } else if ("-".equals(this.operator)) {
            result = Float.valueOf(val1.floatValue() - val2.floatValue());
        } else if ("*".equals(this.operator)) {
            result = Float.valueOf(val1.floatValue() * val2.floatValue());
        } else if ("/".equals(this.operator)) {
            result = Float.valueOf(val1.floatValue() / val2.floatValue());
        }
        return result;
    }

    public class AggregationId {
        List<String> fields = new ArrayList<String>();

        public AggregationId(List<String> fields) {
            this.fields = fields;
        }

        public String buildId(Document document) {
            String field;
            String fieldValue;
            String id = "";
            Iterator<String> iterator = this.fields.iterator();
            while (iterator.hasNext() && !StringUtils.isEmpty((CharSequence)(fieldValue = document.getFieldValue(field = iterator.next())))) {
                id = id + "." + fieldValue;
            }
            if (StringUtils.isEmpty((CharSequence)id)) {
                id = null;
            }
            return id;
        }
    }
}

