/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.FilterIF;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Filter;
import de.tblsoft.solr.pipeline.bean.FiltersPipeline;
import de.tblsoft.solr.pipeline.filter.LastFilter;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class ForkDocumentFilter
extends AbstractFilter {
    List<FilterIF> filterList = new ArrayList<FilterIF>();

    @Override
    public void init() {
        this.initPipelineFilters();
        super.init();
    }

    @Override
    public void document(Document document) {
        this.filterList.get(0).document(document);
        super.document(document);
    }

    @Override
    public void end() {
        this.filterList.get(0).end();
        super.end();
    }

    protected void initPipelineFilters() {
        String includeFilters = this.getProperty("include", null);
        String absoluteFile = IOUtils.getAbsoluteFile(this.getBaseDir(), includeFilters);
        FiltersPipeline filtersPipeline = this.readFiltersFromYamlFile(absoluteFile);
        FilterIF lastFilter = null;
        FilterIF filterInstance = null;
        try {
            for (int i = 0; i < filtersPipeline.getFilter().size(); ++i) {
                Filter filter = filtersPipeline.getFilter().get(i);
                if (filter.getDisabled() != null && filter.getDisabled().booleanValue()) continue;
                filterInstance = PipelineExecuter.createFilterInstance(filter);
                filterInstance.setBaseDir(this.getBaseDir());
                filterInstance.setVariables(this.variables);
                if (lastFilter == null) {
                    lastFilter = filterInstance;
                    continue;
                }
                lastFilter.setNextFilter(filterInstance);
                this.filterList.add(lastFilter);
                lastFilter = filterInstance;
            }
            filterInstance.setNextFilter(new LastFilter());
            this.filterList.add(filterInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.filterList.get(0).init();
    }

    protected FiltersPipeline readFiltersFromYamlFile(String fileName) {
        try {
            FileInputStream input = new FileInputStream(new File(fileName));
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(FiltersPipeline.class));
            FiltersPipeline filters = (FiltersPipeline)yaml.load((InputStream)input);
            ((InputStream)input).close();
            return filters;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

