/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class FuzzyPermutationFilter
extends AbstractFilter {
    private String input;
    private int distance;
    private String output;

    @Override
    public void init() {
        this.input = this.getProperty("input", "token");
        this.output = this.getProperty("output", "permutations");
        this.distance = this.getPropertyAsInt("distance", 2);
        super.init();
    }

    @Override
    public void document(Document document) {
        if (document.getFieldValues(this.input) == null) {
            super.document(document);
            return;
        }
        HashSet<String> permutations = new HashSet<String>();
        for (String value : document.getFieldValues(this.input)) {
            permutations.addAll(this.permutate(value, this.distance));
        }
        document.addField(this.output, new ArrayList<String>(permutations));
        super.document(document);
    }

    private Set<String> permutate(String word, int iterations) {
        HashSet<String> ret = new HashSet<String>();
        ret.add(word);
        if (iterations <= 0) {
            return ret;
        }
        Set<String> permutations = this.permutate(word);
        int newIteration = --iterations;
        for (String permutation : permutations) {
            ret.addAll(this.permutate(permutation, newIteration));
        }
        ret.addAll(permutations);
        return ret;
    }

    private Set<String> permutate(String word) {
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < word.length(); ++i) {
            StringBuilder builder = new StringBuilder(word);
            ret.add(builder.deleteCharAt(i).toString());
        }
        return ret;
    }
}

