/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrepFilter
extends AbstractFilter {
    private String fieldName;
    private Pattern pattern;
    private boolean shouldMatch = true;

    @Override
    public void init() {
        this.fieldName = this.getProperty("fieldName", null);
        this.verify(this.fieldName, "For the GrepFilter a fieldName must be defined.");
        String patternString = this.getProperty("pattern", null);
        this.verify(patternString, "For the GrepFilter a pattern must be defined.");
        this.pattern = Pattern.compile(patternString);
        this.shouldMatch = this.getPropertyAsBoolean("shouldMatch", true);
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> values = document.getFieldValues(this.fieldName, new ArrayList<String>());
        for (String value : values) {
            value = value.replaceAll("\\r\\n|\\r|\\n", " ");
            Matcher m = this.pattern.matcher(value);
            if (this.shouldMatch && !m.matches() || !this.shouldMatch && m.matches()) continue;
            super.document(document);
        }
    }
}

