/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import io.thekraken.grok.api.Grok;
import io.thekraken.grok.api.Match;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokFilter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(GrokFilter.class);
    private String fieldName;
    private Boolean keepRaw;
    private Grok grok;

    @Override
    public void init() {
        this.fieldName = this.getProperty("fieldName", null);
        this.verify(this.fieldName, "For the GrokFilter a fieldName must be defined.");
        this.keepRaw = this.getPropertyAsBoolean("keepRaw", false);
        String grokPattern = this.getProperty("grokPattern", null);
        super.init();
    }

    @Override
    public void document(Document document) {
        super.document(document);
    }

    void processLine(String line) {
        Match gm = this.grok.match(line);
        gm.captures();
        Map m = gm.toMap();
        Document document = new Document();
        for (Map.Entry entry : m.entrySet()) {
            Object value = entry.getValue();
            document.addField((String)entry.getKey(), String.valueOf(value));
        }
    }
}

