/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.filter.HttpWorker;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFilter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(HttpFilter.class);
    private String urlField;
    private CloseableHttpClient httpclient;
    private String userAgent;
    private String cacheBasePath;
    private String fileExtension;
    Duration cacheMaxAge = null;
    private int threads = 1;
    private List<Document> documentQueue = new ArrayList<Document>();
    private ExecutorService executor;

    @Override
    public void init() {
        this.urlField = this.getProperty("urlField", "url");
        this.userAgent = this.getProperty("userAgent", "Solr Cmd Utils Http Agent/1.0");
        this.cacheBasePath = this.getProperty("cacheBasePath", null);
        this.fileExtension = this.getProperty("fileExtension", ".gz");
        this.threads = this.getPropertyAsInt("threads", 1);
        boolean redirectsEnabled = this.getPropertyAsBoolean("redirectsEnabled", false);
        String cacheMaxAgeString = this.getProperty("cacheMaxAge", null);
        if (cacheMaxAgeString != null) {
            this.cacheMaxAge = Duration.parse(cacheMaxAgeString);
        }
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.threads);
        cm.setDefaultMaxPerRoute(this.threads);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setMaxConnPerRoute(this.threads);
        if (!redirectsEnabled) {
            httpClientBuilder = httpClientBuilder.disableRedirectHandling();
        }
        this.httpclient = httpClientBuilder.build();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("tblsoft-http-filter-thread-%d").build();
        this.executor = Executors.newFixedThreadPool(this.threads, namedThreadFactory);
        LOG.info("start http filter with threads: " + this.threads);
        super.init();
    }

    @Override
    public void document(Document document) {
        this.documentQueue.add(document);
        if (this.documentQueue.size() >= this.threads) {
            this.processQueue();
        }
    }

    void processQueue() {
        ArrayList<Future<Document>> documentFutures = new ArrayList<Future<Document>>();
        for (Document document : this.documentQueue) {
            HttpWorker worker = new HttpWorker(document, this.httpclient, this.urlField, this.userAgent, this.cacheBasePath, this.fileExtension, this.cacheMaxAge);
            Future<Document> future = this.executor.submit(worker);
            documentFutures.add(future);
        }
        for (Future future : documentFutures) {
            try {
                Document d = (Document)future.get();
                super.document(d);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        this.documentQueue.clear();
    }

    @Override
    public void end() {
        this.processQueue();
        LOG.info("end HttpFilter");
        try {
            this.httpclient.close();
        }
        catch (IOException e) {
            LOG.info(e.getMessage());
        }
        this.executor.shutdown();
        super.end();
    }
}

