/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.cache.FileCache;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.DateUtils;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpWorker
implements Callable<Document> {
    private static Logger LOG = LoggerFactory.getLogger(HttpWorker.class);
    private CloseableHttpClient httpclient;
    private Document document;
    private String urlField;
    private String userAgent;
    private FileCache cache;
    private Duration maxAge;

    public HttpWorker(Document document, CloseableHttpClient httpclient, String urlField, String userAgent, String cacheBasePath, String fileExtension, Duration maxAge) {
        this.document = document;
        this.httpclient = httpclient;
        this.urlField = urlField;
        this.userAgent = userAgent;
        this.cache = new FileCache(cacheBasePath, fileExtension, maxAge);
    }

    @Override
    public Document call() throws Exception {
        String url = this.document.getFieldValue(this.urlField);
        if (url == null) {
            return this.document;
        }
        url = url.trim();
        CloseableHttpResponse response = null;
        try {
            Document cachedDocument = this.cache.readFromCache(url);
            if (cachedDocument != null) {
                return cachedDocument;
            }
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("User-Agent", this.userAgent);
            long start = System.currentTimeMillis();
            response = this.httpclient.execute((HttpUriRequest)httpGet);
            StringBuilder responseBuilder = new StringBuilder();
            responseBuilder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            response.close();
            long duration = System.currentTimeMillis() - start;
            for (Header header : response.getAllHeaders()) {
                this.document.addField("http_header_" + header.getName(), header.getValue());
                this.document.addField("headernames", header.getName());
            }
            this.document.setField("http_size", String.valueOf(responseBuilder.length()));
            this.document.setField("http_duration", String.valueOf(duration));
            this.document.setField("http_code", String.valueOf(response.getStatusLine().getStatusCode()));
            this.document.setField("http_payload", responseBuilder.toString());
            this.document.setField("http_time", DateUtils.date2String(new Date()));
            this.cache.writeToCache(url, this.document);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.document.addField("errormessage", e.getMessage());
        }
        return this.document;
    }
}

