/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.DateUtils;
import java.util.Date;

public class IgnoreDocumentFilter
extends AbstractFilter {
    private int count;
    private int offset;
    private Date fromDate;
    private Date toDate;
    private String dateField;

    @Override
    public void init() {
        this.fromDate = this.getPropertyAsDate("fromDate", null);
        this.toDate = this.getPropertyAsDate("toDate", null);
        this.dateField = this.getProperty("dateField", "date");
        this.offset = this.getPropertyAsInt("offset", 0);
        super.init();
    }

    @Override
    public void document(Document document) {
        ++this.count;
        if (this.fromDate != null) {
            String dateString = document.getFieldValue(this.dateField);
            Date date = DateUtils.getDate(dateString);
            if (date.compareTo(this.fromDate) > 0 && date.compareTo(this.toDate) < 0) {
                super.document(document);
            }
        } else if (this.count > this.offset) {
            super.document(document);
        }
    }
}

