/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.DocumentBuilder;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.util.ArrayList;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.FileUtils;

public class JavaScriptFilter
extends AbstractFilter {
    private String filename;
    private String script;
    private ScriptEngine engine;
    private CompiledScript compiledScript;

    @Override
    public void init() {
        String internalFilename = this.getProperty("filename", null);
        this.verify(internalFilename, "For the JavaScriptFilter a filename property must be defined.");
        this.filename = IOUtils.getAbsoluteFile(this.getBaseDir(), internalFilename);
        this.script = this.getProperty("script", null);
        ScriptEngineManager mgr = new ScriptEngineManager();
        this.engine = mgr.getEngineByName("JavaScript");
        try {
            if (this.filename != null) {
                this.script = FileUtils.readFileToString((File)new File(this.filename));
            }
            Compilable compEngine = (Compilable)((Object)this.engine);
            this.compiledScript = compEngine.compile(this.script);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        try {
            this.engine.put("input", document);
            DocumentBuilder documentBuilder = new DocumentBuilder();
            this.engine.put("documentBuilder", documentBuilder);
            ArrayList output = new ArrayList();
            this.engine.put("output", output);
            this.compiledScript.eval();
            for (Document d : output) {
                super.document(d);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
        super.end();
    }
}

