/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import de.tblsoft.solr.http.ElasticHelper;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWriter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(JsonWriter.class);
    private Gson gson;
    private String type;
    private String location;
    private String elasticMappingLocation;
    private boolean delete;
    private String idField;
    private String absoluteFilename;

    @Override
    public void init() {
        this.type = this.getProperty("type", "file");
        Boolean pretty = this.getPropertyAsBoolean("pretty", false);
        this.location = this.getProperty("location", null);
        if ("file".equals(this.type)) {
            this.absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), this.location);
        }
        this.verify(this.location, "For the JsonWriter a location must be defined.");
        this.delete = this.getPropertyAsBoolean("delete", Boolean.TRUE);
        this.elasticMappingLocation = this.getProperty("elasticMappingLocation", null);
        this.idField = this.getProperty("idField", null);
        GsonBuilder builder = new GsonBuilder();
        if (pretty.booleanValue()) {
            builder = builder.setPrettyPrinting();
        }
        this.gson = builder.create();
        if (this.delete && "file".equals(this.type)) {
            FileUtils.deleteQuietly((File)new File(this.absoluteFilename));
        }
        super.init();
    }

    static Object transformDatatype(Field field) {
        String value = field.getValue();
        if (field.getDatatype() != null && "string".equals(field.getDatatype())) {
            return value;
        }
        if (NumberUtils.isNumber((String)value)) {
            try {
                Long intValue = Long.valueOf(value);
                return intValue;
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    @Override
    public void document(Document document) {
        Map<String, Object> jsonDocument = JsonWriter.mapToJson(document);
        if (!jsonDocument.isEmpty()) {
            String json = this.gson.toJson(jsonDocument);
            if ("elastic".equals(this.type)) {
                String elasticLocation = this.location;
                if (this.idField != null) {
                    String id = document.getFieldValue(this.idField);
                    elasticLocation = ElasticHelper.getIndexUrlWithId(this.location, id);
                }
                HTTPHelper.post(elasticLocation, json);
            } else if ("elasticupdate".equals(this.type)) {
                int status;
                String updateJson;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.idField == null) {
                    throw new RuntimeException("For a document update a id field is required.");
                }
                String id = document.getFieldValue(this.idField);
                String elasticUpdateLocation = ElasticHelper.getUpdateUrl(this.location, id);
                String response = HTTPHelper.post(elasticUpdateLocation, updateJson = "{ \"doc\" : " + json + "}");
                JsonElement jsonResponse = (JsonElement)this.gson.fromJson(response, JsonElement.class);
                if (jsonResponse.getAsJsonObject().get("status") != null && (status = jsonResponse.getAsJsonObject().get("status").getAsInt()) == 404) {
                    String elasticLocation = ElasticHelper.getIndexUrlWithId(this.location, id);
                    HTTPHelper.post(elasticLocation, json);
                }
            } else if ("file".equals(this.type)) {
                try {
                    FileUtils.writeStringToFile((File)new File(this.absoluteFilename), (String)json, (boolean)true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("stdout".equals(this.type)) {
                LOG.info(json);
            }
        }
        super.document(document);
    }

    public static String mapToJsonString(List<Document> documentList) {
        ArrayList<Map<String, Object>> documentMap = new ArrayList<Map<String, Object>>();
        for (Document document : documentList) {
            documentMap.add(JsonWriter.mapToJson(document));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(documentMap);
        return json;
    }

    static Map<String, Object> mapToJson(Document document) {
        HashMap<String, Object> jsonDocument = new HashMap<String, Object>();
        for (Field field : document.getFields()) {
            List<String> values = field.getValues();
            if (values == null || values.isEmpty()) continue;
            if (values.size() == 1) {
                jsonDocument.put(field.getName(), JsonWriter.transformDatatype(field));
                continue;
            }
            jsonDocument.put(field.getName(), field.getValues());
        }
        return jsonDocument;
    }

    @Override
    public void end() {
        super.end();
    }
}

