/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaWriter
extends AbstractFilter {
    private Producer<String, String> producer;
    private String idField = "id";
    private String topic;

    @Override
    public void init() {
        try {
            String kafkaServers = this.getProperty("kafkaServers", "localhost:9092");
            String clientId = this.getProperty("clientId", "solr-cmd-utils");
            this.topic = this.getProperty("topic", null);
            this.producer = KafkaWriter.createProducer(kafkaServers, clientId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    private static Producer<String, String> createProducer(String kafkaServers, String clientId) {
        Properties props = new Properties();
        props.put("bootstrap.servers", kafkaServers);
        props.put("client.id", clientId);
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        return new KafkaProducer(props);
    }

    @Override
    public void document(Document document) {
        try {
            String id = document.getFieldValue(this.idField);
            ProducerRecord record = new ProducerRecord(this.topic, (Object)id, (Object)document.toString());
            RecordMetadata recordMetadata = (RecordMetadata)this.producer.send(record).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.document(document);
    }

    @Override
    public void end() {
        this.producer.flush();
        this.producer.close();
        super.end();
    }
}

