/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.DocumentUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class KeyValueSplitterFilter
extends AbstractFilter {
    private String fieldName;
    private String delimiter;
    private String keyValueDelimiter;
    private String keyPrefix;
    private boolean normalizeKey;

    @Override
    public void init() {
        this.fieldName = this.getProperty("fieldName", null);
        this.verify(this.fieldName, "For the KeyValueSplitterFilter a fieldName must be defined.");
        this.delimiter = this.getProperty("delimiter", "|");
        this.verify(this.delimiter, "For the KeyValueSplitterFilter a delimiter must be defined.");
        this.keyValueDelimiter = this.getProperty("keyValueDelimiter", "=");
        this.verify(this.keyValueDelimiter, "For the KeyValueSplitterFilter a keyValueDelimiter must be defined.");
        this.keyPrefix = this.getProperty("keyPrefix", "");
        this.normalizeKey = this.getPropertyAsBoolean("normalizeKey", true);
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> values = document.getFieldValues(this.fieldName, new ArrayList<String>());
        for (String value : values) {
            String[] splittedValues;
            for (String splittedValue : splittedValues = value.split(Pattern.quote(this.delimiter))) {
                Field field = this.processKeyValue(splittedValue);
                if (field == null) continue;
                document.addField(field);
            }
        }
        super.document(document);
    }

    Field processKeyValue(String keyValue) {
        if (Strings.isNullOrEmpty((String)keyValue)) {
            return null;
        }
        String[] splittedValue = keyValue.split(Pattern.quote(this.keyValueDelimiter));
        if (splittedValue.length != 2) {
            return null;
        }
        String key = this.keyPrefix + splittedValue[0];
        if (this.normalizeKey) {
            key = DocumentUtils.normalizeFieldKey(key);
        }
        Field field = new Field(key, splittedValue[1]);
        return field;
    }
}

