/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import de.tblsoft.solr.util.OutputStreamStringBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LibSvmWriter
extends AbstractFilter {
    private String featmapInFilepath;
    private String featmapOutFilepath;
    private String svmFilepath;
    private String svmFieldLabel;
    private List<String> svmFields;
    private OutputStream svmOutputStream;
    private OutputStreamStringBuilder svmOutputStreamStringBuilder;
    Map<String, Integer> featmap;

    @Override
    public void init() {
        this.featmap = new LinkedHashMap<String, Integer>();
        String relativeFeatmapInFilepath = this.getProperty("featmapInFilepath", null);
        if (relativeFeatmapInFilepath != null) {
            this.featmapInFilepath = IOUtils.getAbsoluteFile(this.getBaseDir(), relativeFeatmapInFilepath);
            try {
                this.featmap = LibSvmWriter.loadFeatmap(this.featmapInFilepath);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load featmap!", e);
            }
        }
        String relativeFeatmapOutFilepath = this.getProperty("featmapOutFilepath", null);
        this.featmapOutFilepath = IOUtils.getAbsoluteFile(this.getBaseDir(), relativeFeatmapOutFilepath);
        this.verify(this.featmapOutFilepath, "A featmapOutFilepath must be defined!");
        this.svmFilepath = this.getProperty("svmFilepath", null);
        this.verify(this.svmFilepath, "svmFilepath must be defined!");
        this.svmFieldLabel = this.getProperty("svmFieldLabel", null);
        this.verify(this.svmFieldLabel, "svmFieldLabel must be defined!");
        this.svmFields = this.getPropertyAsList("svmFields", null);
        this.verify(this.svmFields, "svmFields must be defined!");
        try {
            this.svmOutputStream = IOUtils.getOutputStream(this.svmFilepath);
            this.svmOutputStreamStringBuilder = new OutputStreamStringBuilder(this.svmOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        if (document != null) {
            String svmLine = this.serializeDocToSvm(document);
            this.svmOutputStreamStringBuilder.append(svmLine);
            this.svmOutputStreamStringBuilder.append("\n");
        }
        super.document(document);
    }

    @Override
    public void end() {
        try {
            this.svmOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error when closing svmOutputStream!", e);
        }
        try {
            LibSvmWriter.saveFeatmap(this.featmapOutFilepath, this.featmap);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save featmap!", e);
        }
        super.end();
    }

    public String serializeDocToSvm(Document doc) {
        StringBuilder svmLineBuilder = new StringBuilder();
        String label = doc.getFieldValue(this.svmFieldLabel);
        svmLineBuilder.append(label);
        svmLineBuilder.append(" ");
        Integer featureIndex = 1;
        for (String svmField : this.svmFields) {
            Field featureField = doc.getField(svmField);
            String svmFeatureValue = this.getSvmFeatureValue(featureField, featureIndex);
            if (svmFeatureValue != null) {
                svmLineBuilder.append(svmFeatureValue);
                svmLineBuilder.append(" ");
            }
            Integer n = featureIndex;
            Integer n2 = featureIndex = Integer.valueOf(featureIndex + 1);
        }
        return svmLineBuilder.toString().trim();
    }

    protected Integer updateFeatureMap(String feature) {
        Integer index = null;
        if (!this.featmap.containsKey(feature)) {
            index = this.featmap.size() + 1;
            this.featmap.put(feature, index);
        } else {
            index = this.featmap.get(feature);
        }
        return index;
    }

    protected String getSvmFeatureValue(Field featureField, Integer featureIndex) {
        String featureValue = null;
        if (featureField.getValue() != null) {
            if (!StringUtils.isNumeric((CharSequence)featureField.getValue())) {
                String featureName = LibSvmWriter.getFeatmapFeatureName(featureField.getName(), featureField.getValue());
                Integer encodedOrdinalValue = this.updateFeatureMap(featureName);
                featureValue = LibSvmWriter.serializeSvmFeatureValue(featureIndex, encodedOrdinalValue);
            } else {
                featureValue = LibSvmWriter.serializeSvmFeatureValue(featureIndex, featureField.getValue());
            }
        }
        return featureValue;
    }

    public static String serializeSvmFeatureValue(Integer index, Object value) {
        return index + ":" + value;
    }

    public static String getFeatmapFeatureName(String field, Object value) {
        String featureName = null;
        if (value != null && value instanceof String) {
            featureName = value.toString();
        }
        return featureName;
    }

    public static Map<String, Integer> loadFeatmap(String filepath) throws IOException {
        LinkedHashMap<String, Integer> featmap = new LinkedHashMap<String, Integer>();
        try (BufferedReader br = new BufferedReader(new FileReader(filepath));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] parts = line.split("\\s");
                if (!"i".equals(parts[2]) && !"q".equals(parts[2])) continue;
                int index = Integer.parseInt(parts[0]);
                String feature = parts[1];
                featmap.put(feature, index);
            }
        }
        return featmap;
    }

    public static void saveFeatmap(String filepath, Map<String, Integer> featmap) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), "UTF-8"));){
            for (Map.Entry<String, Integer> entry : featmap.entrySet()) {
                String line = entry.getValue() + "\t" + entry.getKey() + "\ti\n";
                out.append(line);
            }
        }
    }
}

