/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;

public class LinkCheckerFilter
extends AbstractFilter {
    private String urlFieldName;
    private String httpCodeFieldName;
    private String statusFieldName;
    private String messageFieldName;

    @Override
    public void init() {
        this.urlFieldName = this.getProperty("urlFieldName", "url");
        this.httpCodeFieldName = this.getProperty("httpCodeFieldName", "httpCode");
        this.statusFieldName = this.getProperty("statusFieldName", "status");
        this.messageFieldName = this.getProperty("messageFieldName", "message");
        super.init();
    }

    @Override
    public void document(Document document) {
        String status;
        String httpCode;
        String url = document.getFieldValue(this.urlFieldName);
        String message = "";
        if (Strings.isNullOrEmpty((String)url)) {
            httpCode = "0";
            status = "NOURL";
        } else {
            try {
                int httpStatusCode = HTTPHelper.getStatusCode(url);
                httpCode = String.valueOf(httpStatusCode);
                status = "UNKNOWN";
                if (httpStatusCode >= 100 && httpStatusCode < 200) {
                    status = "INFORMATION";
                }
                if (httpStatusCode >= 200 && httpStatusCode < 300) {
                    status = "OK";
                }
                if (httpStatusCode >= 300 && httpStatusCode < 400) {
                    status = "REDIRECT";
                }
                if (httpStatusCode >= 400 && httpStatusCode < 500) {
                    status = "CLIENT_ERROR";
                }
                if (httpStatusCode >= 500 && httpStatusCode < 600) {
                    status = "SERVER_ERROR";
                }
                if (httpStatusCode >= 900 && httpStatusCode < 1000) {
                    status = "PROPRIETARY";
                }
            }
            catch (Exception e) {
                httpCode = "0";
                status = "URL_ERROR";
            }
        }
        document.addField(this.httpCodeFieldName, httpCode);
        document.addField(this.messageFieldName, message);
        document.addField(this.statusFieldName, status);
        super.document(document);
    }
}

