/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.filter.SimpleMapping;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupFilter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(LookupFilter.class);
    private Map<String, Document> lookup = new HashMap<String, Document>();
    private String keyField;
    private List<String> keyNormalizationFunctions;

    @Override
    public void init() {
        this.keyField = this.getProperty("keyField", "key");
        String keyNormalization = this.getProperty("keyNormalization", "");
        this.keyNormalizationFunctions = Arrays.asList(keyNormalization.split(Pattern.quote("|")));
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> keyList = document.getFieldValues(this.keyField);
        for (String key : keyList) {
            String normalizedKey = this.normalizeKey(key);
            LOG.info("############ " + normalizedKey);
            this.lookup.put(normalizedKey, document);
        }
        super.document(document);
    }

    public String normalizeKey(String key) {
        String normalizedKey = key;
        SimpleMapping simpleMapping = new SimpleMapping();
        for (String function : this.keyNormalizationFunctions) {
            normalizedKey = simpleMapping.executeFunction(function, normalizedKey);
        }
        return normalizedKey;
    }

    public Map<String, Document> getLookup() {
        return this.lookup;
    }
}

