/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.pipeline.bean.FieldComperator;
import de.tblsoft.solr.pipeline.filter.AbstractSubFieldFilter;
import de.tblsoft.solr.pipeline.filter.SimpleMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;

public class MappingFilter
extends AbstractSubFieldFilter {
    private List<String> prefixMapping = new ArrayList<String>();
    private Map<String, List<String>> mapping = new HashMap<String, List<String>>();
    private Map<String, List<String>> mappingFunctions = new HashMap<String, List<String>>();
    private Map<String, String> joins = new HashMap<String, String>();
    private Map<String, String> datatypes = new HashMap<String, String>();
    private boolean sortFieldsByName = false;
    private boolean addEmptyFieldIfNotExists = false;
    private boolean appendFields = false;
    private SimpleMapping simpleMapping;

    @Override
    public void init() {
        this.sortFieldsByName = this.getPropertyAsBoolean("sortFieldsByName", false);
        this.addEmptyFieldIfNotExists = this.getPropertyAsBoolean("addEmptyFieldIfNotExists", false);
        this.appendFields = this.getPropertyAsBoolean("appendFields", false);
        this.simpleMapping = new SimpleMapping(this.getPropertyAsList("mapping", new ArrayList<String>()), this.getPropertyAsList("config", new ArrayList<String>()));
        this.mapping = this.simpleMapping.getMapping();
        this.prefixMapping = this.getPropertyAsList("prefixMapping", new ArrayList<String>());
        this.mappingFunctions = this.simpleMapping.getMappingFunctions();
        this.joins = this.simpleMapping.getJoins();
        this.datatypes = this.initDatatypes(this.getPropertyAsList("datatypes", new ArrayList<String>()));
        super.init();
    }

    Map<String, String> initDatatypes(List<String> datatypeConfig) {
        HashMap<String, String> datatypes = new HashMap<String, String>();
        for (String datatypeConfigEntry : datatypeConfig) {
            String[] s = datatypeConfigEntry.split("->");
            if (s.length != 2) continue;
            datatypes.put(s[0], s[1]);
        }
        return datatypes;
    }

    @Override
    public List<Document> processDocument(Document document) {
        Document mappedDocument;
        if (!this.appendFields) {
            mappedDocument = new Document();
        } else {
            mappedDocument = new Document();
            mappedDocument.getFields().addAll(document.getFields());
        }
        for (Field field : document.getFields()) {
            for (String string : this.prefixMapping) {
                if (!field.getName().startsWith(string)) continue;
                mappedDocument.addField(field);
            }
            List<String> mappedNameList = this.mapping.get(field.getName());
            if (mappedNameList == null) continue;
            for (String mappedName : mappedNameList) {
                List<String> mappedFunctions = this.mappingFunctions.get(mappedName);
                if (Strings.isNullOrEmpty((String)mappedName)) continue;
                ArrayList<String> newValues = new ArrayList<String>();
                Iterator<String> iterator = field.getValues().iterator();
                while (iterator.hasNext()) {
                    String value;
                    String newValue = value = iterator.next();
                    for (String function : mappedFunctions) {
                        newValue = this.simpleMapping.executeFunction(function, newValue);
                    }
                    newValues.add(newValue);
                }
                mappedDocument.addField(mappedName, newValues);
                Field mappedField = mappedDocument.getField(mappedName);
                mappedField.setDatatype(this.datatypes.get(mappedField.getName()));
                for (String function : mappedFunctions) {
                    SimpleMapping.executeFieldFunction(function, mappedField);
                }
            }
        }
        for (Map.Entry entry : this.joins.entrySet()) {
            HashMap<String, String> documentMap = new HashMap<String, String>();
            for (Field field : document.getFields()) {
                documentMap.put(field.getName(), field.getValue());
            }
            StrSubstitutor strSubstitutor = new StrSubstitutor(documentMap);
            String value = strSubstitutor.replace((String)entry.getValue());
            mappedDocument.setField((String)entry.getKey(), value);
        }
        if (mappedDocument.getFields().size() != 0) {
            this.addMissingFields(mappedDocument);
            this.sortFieldsByName(mappedDocument);
            return Arrays.asList(mappedDocument);
        }
        return null;
    }

    void sortFieldsByName(Document mappedDocument) {
        if (!this.sortFieldsByName) {
            return;
        }
        Collections.sort(mappedDocument.getFields(), new FieldComperator());
    }

    void addMissingFields(Document mappedDocument) {
        if (!this.addEmptyFieldIfNotExists) {
            return;
        }
        HashSet<String> mappedFieldNames = new HashSet<String>();
        for (Field field : mappedDocument.getFields()) {
            mappedFieldNames.add(field.getName());
        }
        for (Map.Entry entry : this.mapping.entrySet()) {
            for (String mappedName : (List)entry.getValue()) {
                if (mappedFieldNames.contains(mappedName)) continue;
                mappedDocument.addField(mappedName, "");
            }
        }
    }
}

