/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;

public class MessageDigestFilter
extends AbstractFilter {
    private String algorithm;
    private String salt;
    private List<String> fields;
    private MessageDigest md;

    @Override
    public void init() {
        this.algorithm = this.getProperty("algorithm", "SHA-512");
        this.salt = this.getProperty("salt", null);
        this.fields = this.getPropertyAsList("fields", null);
        this.verify(this.fields, "For the MessageDigestFilter fields must be defined!");
        try {
            this.md = MessageDigest.getInstance(this.algorithm);
            this.md.update(this.salt.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document doc) {
        this.encode(doc);
        super.document(doc);
    }

    public void encode(Document doc) {
        for (String field : this.fields) {
            ArrayList<String> encodedValues = new ArrayList<String>();
            List<String> fieldValues = doc.getFieldValues(field);
            if (fieldValues == null) continue;
            for (String value : doc.getFieldValues(field)) {
                if (value == null) continue;
                String encodedValue = this.encode(value);
                encodedValues.add(encodedValue);
            }
            doc.setField(field, (List<String>)encodedValues);
        }
    }

    public String encode(String value) {
        byte[] bytes = this.md.digest(value.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])bytes);
    }
}

