/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.List;

public class Multivalue2DocumentFilter
extends AbstractFilter {
    private String fieldName;

    @Override
    public void init() {
        this.fieldName = this.getProperty("fieldName", null);
        this.verify(this.fieldName, "For the Multivalue2DocumentFilter a fieldName property must be defined.");
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> values = document.getFieldValues(this.fieldName);
        if (values == null) {
            super.document(document);
        } else {
            for (String value : values) {
                Document newDocument = new Document(document);
                newDocument.setField(this.fieldName, value);
                super.document(newDocument);
            }
        }
    }
}

