/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import de.tblsoft.solr.util.OutputStreamStringBuilder;
import java.io.IOException;
import java.io.OutputStream;

public class N3Writer
extends AbstractFilter {
    private String absoluteFilename;
    private OutputStream outputStream;
    private OutputStreamStringBuilder outputStreamStringBuilder;

    @Override
    public void init() {
        String relativeFilename = this.getProperty("filename", null);
        this.absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), relativeFilename);
        this.verify(this.absoluteFilename, "For the FileLineWriter a filname must be defined.");
        try {
            this.outputStream = IOUtils.getOutputStream(this.absoluteFilename);
            this.outputStreamStringBuilder = new OutputStreamStringBuilder(this.outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        try {
            String subject = document.getFieldValue("subject");
            String predicate = document.getFieldValue("predicate");
            String object = document.getFieldValue("object");
            subject = subject.replaceAll(" ", "_");
            predicate = predicate.replaceAll(" ", "_");
            object = object.replaceAll("\n", " ");
            this.outputStreamStringBuilder.append("<").append(subject).append(">").append("\t");
            this.outputStreamStringBuilder.append("<").append(predicate).append(">").append("\t");
            this.outputStreamStringBuilder.append("\"").append(object).append("\"");
            this.outputStreamStringBuilder.append("\n");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.document(document);
    }

    @Override
    public void end() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.end();
    }
}

