/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import de.tblsoft.solr.logic.LinguisticHelper;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class NounExtractorFilter
extends AbstractFilter {
    private Set<String> dictionary = new HashSet<String>();
    private List<String> fieldWhiteList;
    private List<String> fieldBlackList;

    @Override
    public void end() {
        ArrayList<String> dictionaryList = new ArrayList<String>(this.dictionary);
        Collections.sort(dictionaryList);
        for (String value : dictionaryList) {
            Document document = new Document();
            document.addField("noun", value);
            super.document(document);
        }
        super.end();
    }

    @Override
    public void init() {
        this.fieldWhiteList = this.getPropertyAsList("fieldWhiteList", null);
        this.fieldBlackList = this.getPropertyAsList("fieldBlackList", null);
        super.init();
    }

    @Override
    public void document(Document document) {
        for (Field field : document.getFields()) {
            for (String value : field.getValues()) {
                this.field(field.getName(), value);
            }
        }
    }

    private void field(String name, String value) {
        if (this.isFieldIncluded(name)) {
            this.dictionary.addAll(this.tokenize(value));
        }
    }

    boolean isFieldIncluded(String name) {
        if (this.fieldBlackList != null) {
            for (String item : this.fieldBlackList) {
                if (!name.matches(item)) continue;
                return false;
            }
        }
        if (this.fieldWhiteList != null) {
            for (String item : this.fieldWhiteList) {
                if (!name.matches(item)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    boolean isFirstCharUpperCase(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return false;
        }
        if (value.length() < 3) {
            return false;
        }
        char firstChar = value.charAt(0);
        char secondChar = value.charAt(2);
        return Character.isUpperCase(firstChar) && Character.isLowerCase(secondChar);
    }

    Set<String> tokenize(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value);
        HashSet<String> values = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (!this.isFirstCharUpperCase(token) || !LinguisticHelper.containsOnlyGermanCharacters(token)) continue;
            values.add(token.toLowerCase());
        }
        return values;
    }
}

